<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.min.css">
<style>
    /* Variabel Warna dari Palet Utama Anda */
    :root {
        --main-bg-color: #f8f8f8;
        --main-text-color: #333;
        --card-bg-color: #fff;
        --card-border-color: #eee;
        --primary-accent: #E91E63; /* Pink */
        --secondary-accent: #00BCD4; /* Cyan/Mint */
    }

    body {
        background-color: var(--main-bg-color);
        color: var(--main-text-color);
    }

    .hero-section {
        background-color: var(--main-bg-color);
        padding: 5rem 0;
        text-align: center;
    }
    .hero-section h1 {
        font-weight: bold;
    }

    .works-section {
        padding: 2rem 0;
    }

    .card {
        border: 1px solid var(--card-border-color);
        border-radius: 10px;
        box-shadow: 0 4px 8px rgba(0,0,0,0.05);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 16px rgba(0,0,0,0.1);
    }

    .card-img-top {
        border-top-left-radius: 10px;
        border-top-right-radius: 10px;
        height: 200px; /* Atur tinggi gambar agar seragam */
        object-fit: cover; /* Pastikan gambar tidak terdistorsi */
    }

    .card-body {
        display: flex;
        flex-direction: column;
        justify-content: space-between;
    }

    .card-title {
        position: relative;
        font-weight: bold;
        padding-bottom: 10px;
        transition: all 0.3s ease; /* Tambahkan transisi untuk efek halus */
    }
    .card-title::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        width: 40px;
        height: 3px;
        background-color: var(--secondary-accent);
        border-radius: 2px;
        transition: width 0.3s ease; /* Tambahkan transisi untuk efek halus */
    }

    /* Efek hover: garis bawah memanjang saat card di-hover */
    .card:hover .card-title::after {
        width: 100%;
    }

    /* Gaya tombol */
    .btn-custom {
        background-color: var(--primary-accent);
        border-color: var(--primary-accent);
        color: #fff;
        transition: background-color 0.3s ease, transform 0.2s ease;
    }
    .btn-custom:hover {
        background-color: var(--secondary-accent); /* Diubah ke warna biru saat hover */
        border-color: var(--secondary-accent);
        transform: scale(1.05);
        color: #fff;
    }

    .btn-custom .bi {
        font-size: 1.2rem;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    
    <?php
    $works = [
        [
            'title' => 'Generative AI Art Project',
            'description' => 'Produksi untuk klien: Sebuah seri karya seni generatif yang dihasilkan oleh algoritma AI.',
            'image' => 'https://th.bing.com/th?id=OVFT.8yV14u9J9LKsnnSdTU_qwi&pid=News&w=300&h=186&c=14&rs=2&qlt=90&dpr=1.3',
            'link' => '#detail1'
        ],
        [
            'title' => 'Interaktif Data Visualisasi',
            'description' => 'Membuat visualisasi interaktif untuk laporan tahunan sebuah perusahaan, menampilkan data yang kompleks secara sederhana.',
            'image' => 'https://th.bing.com/th?id=OVFT.8yV14u9J9LKsnnSdTU_qwi&pid=News&w=300&h=186&c=14&rs=2&qlt=90&dpr=1.3',
            'link' => '#detail2'
        ],
        [
            'title' => 'Creative Coding untuk Branding',
            'description' => 'Pengembangan logo dan visual identitas brand yang dapat bereaksi terhadap suara dan gerakan pengguna.',
            'image' => 'https://th.bing.com/th?id=OVFT.8yV14u9J9LKsnnSdTU_qwi&pid=News&w=300&h=186&c=14&rs=2&qlt=90&dpr=1.3',
            'link' => '#detail3'
        ],
        [
            'title' => 'Instalasi Seni Digital',
            'description' => 'Membuat instalasi seni yang menampilkan visual berbasis kode untuk pameran di museum seni kontemporer.',
            'image' => 'https://th.bing.com/th?id=OVFT.8yV14u9J9LKsnnSdTU_qwi&pid=News&w=300&h=186&c=14&rs=2&qlt=90&dpr=1.3',
            'link' => '#detail4'
        ],
    ];
    ?>

    <div class="hero-section animated-gradient-banner">
        <div class="container">
            <h1>Visual storytelling through the lens of code.</h1>
            <p class="lead">
                I am a visual storyteller focusing on the intersection of science, arts, technology, and culture.
                My work explores how we can use digital mediums to create new narratives and experiences.
            </p>
        </div>
    </div>

    <div class="my-5 container">
        <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4">
            <?php $__currentLoopData = $works; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $work): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col d-flex">
                <div class="card h-100">
                    <img src="<?php echo e($work['image']); ?>" class="card-img-top" alt="<?php echo e($work['title']); ?>">
                    <div class="card-body d-flex flex-column">
                        <div>
                            <h5 class="card-title"><?php echo e($work['title']); ?></h5>
                            <p class="card-text"><?php echo e($work['description']); ?></p>
                        </div>
                        <div class="d-flex justify-content-end mt-auto">
                            <a href="<?php echo e($work['link']); ?>" class="btn btn-custom" aria-label="Lihat detail proyek <?php echo e($work['title']); ?>">
                                <i class="bi bi-arrow-right-circle"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Administrator\Desktop\RWNJ\resources\views/works.blade.php ENDPATH**/ ?>