<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Access</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        /* CSS Khusus untuk Tema */
        :root {
            --main-text-color: #333;
            --navbar-bg-color: #fff;
            --navbar-border-color: #eee;
            --primary-accent: #E91E63; /* Pink */
            --secondary-accent: #00BCD4; /* Cyan/Mint */
        }

        body {
            background-color: #f8f9fa; /* Latar belakang abu-abu muda */
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
            color: var(--main-text-color);
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }

        .login-container {
            background-color: var(--navbar-bg-color);
            border-radius: 1rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            padding: 2.5rem;
            max-width: 400px;
            width: 100%;
            text-align: center;
        }

        .login-logo img {
            height: 60px;
            margin-bottom: 1.5rem;
        }

        .login-container h1 {
            color: var(--main-text-color);
            font-size: 1.75rem;
            font-weight: bold;
            margin-bottom: 2rem;
        }

        .form-control {
            border-radius: 0.5rem;
            border: 1px solid var(--navbar-border-color);
            padding: 0.75rem 1rem;
            margin-bottom: 1rem;
        }

        .form-control:focus {
            border-color: var(--secondary-accent);
            box-shadow: 0 0 0 0.2rem rgba(0, 188, 212, 0.25);
        }

        .btn-primary {
            background-color: var(--primary-accent);
            border: none;
            color: #fff;
            font-weight: bold;
            padding: 0.75rem 1.5rem;
            border-radius: 0.5rem;
            transition: background-color 0.3s ease;
            width: 100%;
        }

        .btn-primary:hover {
            background-color: #d81b60; /* Darker pink */
        }

        .alert-danger {
            background-color: #f8d7da;
            color: #721c24;
            border-color: #f5c6cb;
            border-radius: 0.5rem;
            padding: 1rem;
            text-align: left;
            margin-bottom: 1.5rem;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-logo">
            <img src="https://static.vecteezy.com/system/resources/previews/020/448/322/non_2x/rnj-letter-logo-design-in-illustration-logo-calligraphy-designs-for-logo-poster-invitation-etc-vector.jpg" alt="Logo">
        </div>

        <h1>Dashboard Access</h1>

        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <form method="POST" action="<?php echo e(route('access')); ?>">
            <?php echo csrf_field(); ?>
            <div class="mb-3">
                <!-- Username dihapus, hanya menyisakan PIN -->
                <input type="password" class="form-control" name="password" id="password" placeholder="PIN" required>
            </div>
            <button type="submit" class="btn btn-primary">Enter</button>
        </form>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php /**PATH C:\Users\Administrator\Desktop\RWNJ\resources\views/access.blade.php ENDPATH**/ ?>