<?php $__env->startSection('title', 'Edit Piece: ' . $piece->title); ?>

<?php $__env->startPush('styles'); ?>
    <style>
        /* Gaya dasar untuk form dinamis */
        .description-section, .detail-item {
            border: 1px solid #dee2e6;
            border-radius: .25rem;
            padding: 15px;
            margin-bottom: 15px;
            background-color: #f8f9fa;
        }
        .detail-item {
            margin-top: 10px;
            background-color: #e9ecef;
        }
        .section-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 1px solid #dee2e6;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="card">
        <div class="card-body">
            <h5 class="card-title fw-semibold mb-4">Edit Piece: **<?php echo e($piece->title); ?>** 📝</h5>
            <div class="card">
                <div class="card-body">
                    <form action="<?php echo e(route('auth.pieces.update', $piece->id)); ?>" method="POST" enctype="multipart/form-data" id="pieceForm">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?> 

                        
                        <div class="mb-3">
                            <label for="title" class="form-label">Title</label>
                            
                            <input type="text" name="title" id="title" class="form-control <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('title', $piece->title)); ?>" required>
                            <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-3">
                            <label for="category" class="form-label">Category</label>
                            <input type="text" name="category" id="category" class="form-control <?php $__errorArgs = ['category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('category', $piece->category)); ?>" required>
                            <?php $__errorArgs = ['category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="mb-4">
                            <label for="model3d_file" class="form-label">3D Model File (.glb) (Optional: Upload untuk Mengganti)</label>
                            <input type="file" name="model3d_file" id="model3d_file" class="form-control <?php $__errorArgs = ['model3d_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" accept=".glb">
                            <?php $__errorArgs = ['model3d_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            <?php if($piece->model3d): ?>
                                <small class="text-muted mt-2 d-block">Current Model: <a href="<?php echo e($piece->model3d); ?>" target="_blank"><?php echo e(Str::limit($piece->model3d, 60)); ?></a>. Upload baru akan mengganti yang ini.</small>
                            <?php endif; ?>
                        </div>

                        <hr>
                        <h4 class="mb-3">JSON Description Sections 📝</h4>
                        
                        <div id="descriptionContainer">
                            
                        </div>

                        <button type="button" class="btn btn-outline-primary mb-4" id="addSectionBtn">
                            + Add New Section (Description)
                        </button>

                        
                        <input type="hidden" name="description_json" id="descriptionJsonInput">

                        <hr class="mt-4 mb-4">
                        <button type="submit" class="btn btn-primary">Update Piece</button>
                        <a href="<?php echo e(route('auth.pieces.index')); ?>" class="btn btn-outline-secondary ms-2">Cancel</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.getElementById('pieceForm');
            const descriptionContainer = document.getElementById('descriptionContainer');
            const addSectionBtn = document.getElementById('addSectionBtn');
            const descriptionJsonInput = document.getElementById('descriptionJsonInput');
            let sectionIndex = 0;

            // --- FUNGSI PEMBANTU (Sama seperti di create.blade.php) ---

            function createDetailItem(sectionIdx, detailIdx, data = {}) {
                // ... (Isi fungsi createDetailItem yang sama persis dari create.blade.php) ...
                const image = data.image || '';
                const text = data.text || '';
                const posX = data.position?.x || '';
                const posY = data.position?.y || '';
                const pointSize = data.pointSize || '';

                return `
                    <div class="detail-item" data-detail-index="${detailIdx}">
                        <div class="section-header">
                            <h6>Detail Item #${detailIdx + 1}</h6>
                            <button type="button" class="btn btn-sm btn-danger remove-detail-btn" data-section-index="${sectionIdx}" data-detail-index="${detailIdx}">Remove Detail</button>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Image URL</label>
                                <input type="url" class="form-control detail-image" value="${image}" placeholder="https://..." />
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Description Text</label>
                                <input type="text" class="form-control detail-text" value="${text}" />
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Position X (px)</label>
                                <input type="number" class="form-control detail-pos-x" value="${posX}" placeholder="e.g. 200" />
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Position Y (px)</label>
                                <input type="number" class="form-control detail-pos-y" value="${posY}" placeholder="e.g. 50" />
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">PointSize (Optional)</label>
                                <input type="number" class="form-control detail-pointsize" value="${pointSize}" placeholder="e.g. 10" />
                            </div>
                        </div>
                    </div>
                `;
            }

            function createSection(data = {}) {
                // ... (Isi fungsi createSection yang sama persis dari create.blade.php, termasuk event listener binding) ...
                const title = data.title || '';
                const content = data.content || '';
                const rotX = data.transform?.rotation?.x || '0.0';
                const rotY = data.transform?.rotation?.y || '0.0';
                const rotZ = data.transform?.rotation?.z || '0.0';
                const currentSectionIndex = sectionIndex++;

                const sectionDiv = document.createElement('div');
                sectionDiv.classList.add('description-section');
                sectionDiv.setAttribute('data-section-index', currentSectionIndex);

                sectionDiv.innerHTML = `
                    <div class="section-header">
                        <h5 class="mb-0">Section #${currentSectionIndex + 1}</h5>
                        <button type="button" class="btn btn-sm btn-danger remove-section-btn">Remove Section</button>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Section Title</label>
                        <input type="text" class="form-control section-title" value="${title}" required />
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Content</label>
                        <textarea class="form-control section-content" rows="3" required>${content}</textarea>
                    </div>

                    <h6>3D Transform (Rotation)</h6>
                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label class="form-label">Rotation X</label>
                            <input type="number" step="0.1" class="form-control section-rot-x" value="${rotX}" placeholder="e.g. 0.2" />
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Rotation Y</label>
                            <input type="number" step="0.1" class="form-control section-rot-y" value="${rotY}" placeholder="e.g. 0.5" />
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Rotation Z</label>
                            <input type="number" step="0.1" class="form-control section-rot-z" value="${rotZ}" placeholder="e.g. 0.1" />
                        </div>
                    </div>

                    <h6 class="mt-4">Details/Hotspots</h6>
                    <div class="details-container">
                        ${(data.details || []).map((d, dIdx) => createDetailItem(currentSectionIndex, dIdx, d)).join('')}
                    </div>
                    <button type="button" class="btn btn-sm btn-info add-detail-btn mt-2">Add Detail</button>
                `;

                // Bind Remove Section Button
                sectionDiv.querySelector('.remove-section-btn').addEventListener('click', function() {
                    sectionDiv.remove();
                    reindexSections();
                });

                // Bind Add Detail Button
                sectionDiv.querySelector('.add-detail-btn').addEventListener('click', function() {
                    const detailsContainer = sectionDiv.querySelector('.details-container');
                    const detailIdx = detailsContainer.children.length;
                    detailsContainer.insertAdjacentHTML('beforeend', createDetailItem(currentSectionIndex, detailIdx));
                    reindexSections();
                });

                // Bind Remove Detail Buttons (Delegation)
                sectionDiv.addEventListener('click', function(e) {
                    if (e.target.classList.contains('remove-detail-btn')) {
                        e.target.closest('.detail-item').remove();
                        reindexSections();
                    }
                });

                return sectionDiv;
            }

            function reindexSections() {
                // ... (Isi fungsi reindexSections yang sama persis dari create.blade.php) ...
                const sections = descriptionContainer.querySelectorAll('.description-section');
                sectionIndex = 0;
                sections.forEach((section, sIdx) => {
                    section.setAttribute('data-section-index', sIdx);
                    section.querySelector('.section-header h5').textContent = `Section #${sIdx + 1}`;
                    section.querySelector('.add-detail-btn').setAttribute('data-section-index', sIdx);

                    const removeSectionBtn = section.querySelector('.remove-section-btn');
                    if (removeSectionBtn) removeSectionBtn.setAttribute('data-section-index', sIdx);

                    const detailsContainer = section.querySelector('.details-container');
                    const details = detailsContainer.querySelectorAll('.detail-item');
                    details.forEach((detail, dIdx) => {
                        detail.setAttribute('data-detail-index', dIdx);
                        detail.querySelector('.section-header h6').textContent = `Detail Item #${dIdx + 1}`;

                        const removeDetailBtn = detail.querySelector('.remove-detail-btn');
                        if (removeDetailBtn) {
                            removeDetailBtn.setAttribute('data-section-index', sIdx);
                            removeDetailBtn.setAttribute('data-detail-index', dIdx);
                        }
                    });
                    sectionIndex = sIdx + 1;
                });
            }


            // --- LOGIKA UTAMA UNTUK MENGISI DATA LAMA / DATA PIECE YANG ADA ---

            let initialData = [];

            // 1. Cek OLD INPUT (Jika validasi gagal)
            <?php if(old('description_json')): ?>
                // Jika input lama berupa STRING JSON mentah (gagal validasi sebelum decode)
                try {
                    initialData = JSON.parse('<?php echo str_replace(["\n", "\r", "\t"], '', old('description_json')); ?>');
                } catch (e) {
                    console.error("Failed to parse old description_json:", e);
                }
            <?php elseif(old('description')): ?>
                // Jika input lama berupa ARRAY PHP (gagal validasi setelah decode atau error DB)
                try {
                    initialData = <?php echo json_encode(old('description'), 15, 512) ?>;
                } catch (e) {
                    console.error("Failed to parse old description array:", e);
                }
            <?php else: ?>
                // 2. Jika tidak ada old input, gunakan data Piece dari database (ARRAY PHP)
                try {
                    // Karena $piece->description sudah berupa array karena Eloquent casts
                    initialData = <?php echo json_encode($piece->description, 15, 512) ?>;
                } catch (e) {
                    console.error("Failed to parse existing piece description:", e);
                }
            <?php endif; ?>


            // 3. Isi Form dengan Data
            if (initialData && initialData.length > 0) {
                descriptionContainer.innerHTML = '';
                initialData.forEach(data => {
                    descriptionContainer.appendChild(createSection(data));
                });
                reindexSections();
            } else {
                // Jika datanya kosong (walaupun harusnya tidak di edit), tambahkan satu section kosong
                addSectionBtn.click();
            }

            // --- Event Listener Utama (SAMA SEPERTI DI CREATE) ---
            addSectionBtn.addEventListener('click', function() {
                descriptionContainer.appendChild(createSection());
                reindexSections(); // Panggil reindex setelah add
            });

            form.addEventListener('submit', function(e) {
                // ... (Logika form submit untuk membuat JSON string, SAMA PERSIS DENGAN CREATE) ...
                const descriptionData = [];
                const sections = descriptionContainer.querySelectorAll('.description-section');

                sections.forEach(section => {
                    const title = section.querySelector('.section-title').value;
                    const content = section.querySelector('.section-content').value;
                    const rotX = section.querySelector('.section-rot-x').value || 0;
                    const rotY = section.querySelector('.section-rot-y').value || 0;
                    const rotZ = section.querySelector('.section-rot-z').value || 0;

                    const details = [];
                    section.querySelectorAll('.detail-item').forEach(detail => {
                        const posX = detail.querySelector('.detail-pos-x').value;
                        const posY = detail.querySelector('.detail-pos-y').value;
                        const pointSize = detail.querySelector('.detail-pointsize').value;

                        if (posX || posY) {
                            details.push({
                                image: detail.querySelector('.detail-image').value,
                                text: detail.querySelector('.detail-text').value,
                                position: {
                                    x: parseFloat(posX),
                                    y: parseFloat(posY)
                                },
                                ...(pointSize && { pointSize: parseFloat(pointSize) })
                            });
                        }
                    });

                    descriptionData.push({
                        title: title,
                        content: content,
                        transform: {
                            rotation: {
                                x: parseFloat(rotX),
                                y: parseFloat(rotY),
                                z: parseFloat(rotZ)
                            }
                        },
                        details: details
                    });
                });

                // Masukkan ke Input Tersembunyi
                descriptionJsonInput.value = JSON.stringify(descriptionData);
            });

        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.backend_app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Administrator\Desktop\RWNJ\resources\views/backend/pieces/edit.blade.php ENDPATH**/ ?>