<?php $__env->startSection('title', 'Insights Management'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h5 class="card-title fw-semibold">Insights Management</h5>
                    <a href="<?php echo e(route('backend.insights.create')); ?>" class="btn btn-primary">
                        <i class="ti ti-plus"></i> Create New Insight
                    </a>
                </div>

                <?php if(session('success')): ?>
                    <div class="alert alert-success" role="alert">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>
                <?php if(session('error')): ?>
                    <div class="alert alert-danger" role="alert">
                        <?php echo e(session('error')); ?>

                    </div>
                <?php endif; ?>

                <div class="card">
                    <div class="card-body p-4">
                        <div class="table-responsive">
                            <table class="table text-nowrap mb-0 align-middle">
                                <thead class="text-dark fs-4">
                                    <tr>
                                        <th class="border-bottom-0" style="width: 5%;">
                                            <h6 class="fw-semibold mb-0">#</h6>
                                        </th>
                                        <th class="border-bottom-0" style="width: 25%;">
                                            <h6 class="fw-semibold mb-0">Title</h6>
                                        </th>
                                        <th class="border-bottom-0" style="width: 40%;">
                                            <h6 class="fw-semibold mb-0">Summary</h6>
                                        </th>
                                        <th class="border-bottom-0" style="width: 15%;">
                                            <h6 class="fw-semibold mb-0">Keyword</h6>
                                        </th>
                                        <th class="border-bottom-0" style="width: 15%;">
                                            <h6 class="fw-semibold mb-0">Actions</h6>
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $insights; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="border-bottom-0">
                                                <div
                                                    style="width: 15px; height: 15px; background-color: <?php echo e($insight->color ?? '#343a40'); ?>; border-radius: 50%; display: inline-block; margin-right: 8px;">
                                                </div>
                                                <h6 class="fw-semibold mb-0 d-inline"><?php echo e($insight->id); ?></h6>
                                            </td>
                                            <td class="border-bottom-0">
                                                <h6 class="fw-semibold mb-0"><?php echo e($insight->title); ?></h6>
                                            </td>
                                            <td class="border-bottom-0">
                                                <p class="mb-0 fw-normal text-truncate" style="max-width: 300px;">
                                                    <?php echo e($insight->summary); ?></p>
                                            </td>
                                            <td class="border-bottom-0">
                                                <span
                                                    class="badge bg-info rounded-3 fw-semibold"><?php echo e($insight->keyword); ?></span>
                                            </td>
                                            <td class="border-bottom-0">
                                                <div class="d-flex justify-content-start gap-2">
                                                    <a href="<?php echo e(route('backend.insights.edit', $insight->id)); ?>"
                                                        class="btn btn-sm btn-primary">
                                                        Edit
                                                    </a>
                                                    <form action="<?php echo e(route('backend.insights.destroy', $insight->id)); ?>"
                                                        method="POST"
                                                        onsubmit="return confirm('Are you sure you want to delete this insight?');"
                                                        style="display:inline;">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" class="btn btn-sm btn-danger">
                                                            Delete
                                                        </button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <?php if($insights->isEmpty()): ?>
                    <p class="text-center mt-4">No insights found.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend_app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\rahma\Downloads\RWNJ\RWNJ\resources\views/backend/insights/index.blade.php ENDPATH**/ ?>