<?php $__env->startSection('title', 'Links Management'); ?>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h5 class="card-title fw-semibold">Links Management</h5>
                <a href="<?php echo e(route('auth.links.create')); ?>" class="btn btn-primary">
                    <i class="ti ti-plus"></i> Create New Link
                </a>
            </div>

            <?php if(session('success')): ?>
                <div class="alert alert-success" role="alert">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>
            <?php if(session('error')): ?>
                <div class="alert alert-danger" role="alert">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-body p-4">
                    <div class="table-responsive">
                        <table class="table text-nowrap mb-0 align-middle">
                            <thead class="text-dark fs-4">
                                <tr>
                                    <th class="border-bottom-0" style="width: 5%;">
                                        <h6 class="fw-semibold mb-0">Order</h6>
                                    </th>
                                    <th class="border-bottom-0" style="width: 15%;">
                                        <h6 class="fw-semibold mb-0">Icon</h6>
                                    </th>
                                    <th class="border-bottom-0" style="width: 25%;">
                                        <h6 class="fw-semibold mb-0">Name</h6>
                                    </th>
                                    <th class="border-bottom-0" style="width: 40%;">
                                        <h6 class="fw-semibold mb-0">URL</h6>
                                    </th>
                                    <th class="border-bottom-0" style="width: 15%;">
                                        <h6 class="fw-semibold mb-0">Actions</h6>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="border-bottom-0">
                                            <h6 class="fw-semibold mb-0"><?php echo e($link->order); ?></h6>
                                        </td>
                                        <td class="border-bottom-0">
                                            <i class="bi <?php echo e($link->icon); ?>" style="font-size: 1.5rem;"></i>
                                        </td>
                                        <td class="border-bottom-0">
                                            <h6 class="fw-semibold mb-0"><?php echo e($link->name); ?></h6>
                                        </td>
                                        <td class="border-bottom-0">
                                            <a href="<?php echo e($link->url); ?>" target="_blank" class="mb-0 fw-normal text-truncate" style="max-width: 300px;"><?php echo e($link->url); ?></a>
                                        </td>
                                        <td class="border-bottom-0">
                                            <div class="d-flex justify-content-start gap-2">
                                                <a href="<?php echo e(route('auth.links.edit', $link->id)); ?>" class="btn btn-sm btn-primary">
                                                    Edit
                                                </a>
                                                <form action="<?php echo e(route('auth.links.destroy', $link->id)); ?>" method="POST" onsubmit="return confirm('Are you sure you want to delete this link?');" style="display:inline;">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-sm btn-danger">
                                                        Delete
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <?php if($links->isEmpty()): ?>
                <p class="text-center mt-4">No links found.</p>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend_app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Administrator\Desktop\RWNJ\resources\views/backend/links/index.blade.php ENDPATH**/ ?>