<?php $__env->startPush('styles'); ?>
<link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@400;600;700&family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.min.css">

<style>
    /* ------------------------
        GLOBAL
        ------------------------ */
    :root {
        --bg: #ffffff;
        --muted: #6b7280;
        --accent: #7c5cff;
        --accent-2: #ff7ab6;
        --card: #fbfbff;
        --dark-hero: #0b1020;
        --glass: rgba(255,255,255,0.85);
    }
    html, body {
        font-family: 'Quicksand', 'Poppins', sans-serif;
        background: var(--bg);
        color: #111827;
        scroll-behavior: smooth;
    }
    section { padding: 64px 20px; }
    .container { max-width: 1150px; margin: 0 auto; }
    a { color: inherit; text-decoration: none; }

    /* ------------------------
        HERO WORKS
        ------------------------ */
    .hero-works {
        position: relative;
        min-height: 50vh;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #fff;
        overflow: hidden;
        background: linear-gradient(135deg, var(--dark-hero) 0%, #1e2646 100%);
        text-align: center;
    }
    .hero-works::before {
        content: '';
        position: absolute;
        inset: 0;
        /* Garis-garis diagonal atau noise halus */
        background-image: radial-gradient(circle at 100% 100%, #1d2038, transparent 50%),
                          radial-gradient(circle at 0% 0%, #30375a, transparent 50%);
        opacity: 0.15;
    }
    .hero-works-inner { position: relative; z-index: 10; max-width: 800px; }
    .hero-works h1 {
        margin: 0 0 10px 0;
        font-weight: 700;
        font-size: clamp(32px, 5vw, 56px);
        line-height: 1.1;
        letter-spacing: -1px;
    }
    .hero-works p.lead {
        margin: 0;
        color: #b1b5c0;
        font-size: 1.15rem;
        max-width: 60ch;
        margin: 0 auto;
    }

    /* GSAP Animated Elements for mouse follow */
    .parallax-item {
        position: absolute;
        z-index: 5;
        pointer-events: none;
        will-change: transform;
    }
    /* Styling for the animated elements (pure CSS shapes or pseudo-elements) */
    .p-1 { top: 15%; left: 10%; width: 25px; height: 25px; background: var(--accent); opacity: 0.7; border-radius: 50%; filter: blur(4px); }
    .p-2 { bottom: 20%; right: 15%; width: 40px; height: 40px; border: 2px solid var(--accent-2); opacity: 0.6; transform: rotate(45deg); }
    .p-3 { top: 5%; right: 5%; width: 15px; height: 15px; background: #fff; opacity: 0.8; border-radius: 50%; }
    .p-4 { bottom: 10%; left: 5%; width: 60px; height: 6px; background: var(--accent); opacity: 0.3; border-radius: 3px; }


    /* ------------------------
        WORKS GRID
        ------------------------ */
    .works-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 30px;
        padding-top: 32px;
    }

    .work-card {
        background: #fff;
        border-radius: 14px;
        box-shadow: 0 12px 30px rgba(16,24,40,0.06);
        border: 1px solid rgba(10,8,20,0.04);
        overflow: hidden;
        display: flex;
        flex-direction: column;
        transition: transform .3s ease, box-shadow .3s ease;
    }

    .work-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 20px 45px rgba(124,92,255,0.15);
    }

    .card-cover {
        height: 200px; /* Tinggi cover yang konsisten */
        overflow: hidden;
        background: #eee;
    }

    .card-cover img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.4s ease;
    }
    .work-card:hover .card-cover img {
        transform: scale(1.05);
    }

    .card-content {
        padding: 20px;
        flex-grow: 1;
        position: relative;
    }
    .card-content h3 {
        margin: 0 0 6px 0;
        font-size: 1.35rem;
        color: var(--accent);
        line-height: 1.2;
    }
    .card-content h4 {
        margin: 0 0 10px 0;
        font-size: 0.95rem;
        color: #111827;
        font-weight: 600;
    }
    .card-content p {
        color: var(--muted);
        font-size: 0.95rem;
        margin-bottom: 20px;
        /* Membatasi deskripsi */
        display: -webkit-box;
        -webkit-line-clamp: 3;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }
    .card-tags {
        display: flex;
        flex-wrap: wrap;
        gap: 6px;
        margin-top: 12px;
    }
    .card-tags span {
        font-size: 0.75rem;
        font-weight: 600;
        padding: 4px 8px;
        border-radius: 8px;
        background: rgba(124,92,255,0.08);
        color: var(--accent);
    }

    /* Button Ikon Detail */
    .btn-detail {
        position: absolute;
        bottom: 15px;
        right: 15px;
        width: 38px;
        height: 38px;
        display: flex;
        align-items: center;
        justify-content: center;
        background: var(--accent);
        color: #fff;
        border-radius: 50%;
        font-size: 1.1rem;
        box-shadow: 0 4px 12px rgba(124,92,255,0.4);
        transition: transform 0.2s ease, background 0.2s ease;
    }
    .work-card:hover .btn-detail {
        transform: rotate(10deg);
        background: var(--accent-2);
    }

    /* Responsive */
    @media (max-width: 768px) {
        .hero-works { min-height: 35vh; }
        .works-grid { grid-template-columns: 1fr; }
        .card-cover { height: 250px; }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<main class="site-main">

    
    <section class="hero-works" aria-label="Projects showcase header">
        <div class="hero-works-inner">
            <h1 id="heroTitle">My Projects & Experiments</h1>
            <p class="lead" id="heroSubtitle">A collection of things I've built—ranging from full-scale IoT systems to playful creative coding explorations.</p>
        </div>

        
        <div class="parallax-item p-1" data-depth="0.1"></div>
        <div class="parallax-item p-2" data-depth="0.25"></div>
        <div class="parallax-item p-3" data-depth="0.15"></div>
        <div class="parallax-item p-4" data-depth="0.3"></div>
    </section>

    
    <section id="works-list" class="container" aria-label="List of projects">

        <?php if($works->isEmpty()): ?>
            <div style="text-align:center; padding: 40px; color:var(--muted);">
                <i class="bi bi-box-seam" style="font-size: 3rem; color: var(--accent);"></i>
                <h3 style="margin-top:10px;">No projects found yet.</h3>
                <p>Time to get building!</p>
            </div>
        <?php else: ?>
            <div class="works-grid">
                <?php $__currentLoopData = $works; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $work): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="work-card">
                        
                        <div class="card-cover">
                            <img src="<?php echo e($work->cover_path ?? 'https://via.placeholder.com/600x400/7c5cff/ffffff?text=' . urlencode($work->title)); ?>"
                                 alt="Cover image for <?php echo e($work->title); ?>">
                        </div>

                        
                        <div class="card-content">
                            <h3><?php echo e($work->title); ?></h3>
                            <h4><?php echo e($work->subtitle ?? 'Fullstack Development & Creative Tech'); ?></h4>
                            <p><?php echo e($work->description ?? 'A brief summary of the project. Click the button to see the details.'); ?></p>

                            
                            <div class="card-tags">
                                <?php if(is_array($work->tags)): ?>
                                    <?php $__currentLoopData = $work->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span><?php echo e($tag); ?></span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php elseif(!empty($work->tags)): ?>
                                    
                                    <?php
                                        try {
                                            $tags = json_decode($work->tags, true);
                                        } catch (\Exception $e) {
                                            $tags = [$work->tags];
                                        }
                                        if (is_array($tags)) {
                                            $tags = array_filter($tags); // Hapus nilai kosong
                                        } else {
                                            $tags = [trim($work->tags, '[]"')]; // Coba asumsikan string biasa
                                        }
                                    ?>

                                    <?php $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($tag): ?>
                                            <span><?php echo e($tag); ?></span>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>

                            
                            <a href="#" class="btn-detail" aria-label="View project details">
                                <i class="bi bi-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    </section>

</main>
<?php if (isset($component)) { $__componentOriginale940ec5eeeccd956e4aae389c52fb078 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale940ec5eeeccd956e4aae389c52fb078 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.floating-ctas','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('floating-ctas'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale940ec5eeeccd956e4aae389c52fb078)): ?>
<?php $attributes = $__attributesOriginale940ec5eeeccd956e4aae389c52fb078; ?>
<?php unset($__attributesOriginale940ec5eeeccd956e4aae389c52fb078); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale940ec5eeeccd956e4aae389c52fb078)): ?>
<?php $component = $__componentOriginale940ec5eeeccd956e4aae389c52fb078; ?>
<?php unset($__componentOriginale940ec5eeeccd956e4aae389c52fb078); ?>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/ScrollTrigger.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    gsap.registerPlugin(ScrollTrigger);
    const ease = "power3.out";

    // ------------------------
    // Hero Entrance Animation (Initial Load)
    // ------------------------
    gsap.from("#heroTitle", { y: 20, opacity: 0, duration: 1.2, ease: ease });
    gsap.from("#heroSubtitle", { y: 10, opacity: 0, duration: 1, delay: 0.15, ease: ease });

    // Animate the parallax items fading in
    gsap.from(".parallax-item", { scale: 0.5, opacity: 0, duration: 1.5, stagger: 0.1, ease: "elastic.out(1, 0.7)" });

    // ------------------------
    // Mouse Parallax Effect (Interactive GSAP Hero)
    // ------------------------
    const heroSection = document.querySelector('.hero-works');
    const parallaxItems = gsap.utils.toArray('.parallax-item');

    if (heroSection && parallaxItems.length > 0) {
        heroSection.addEventListener('mousemove', (e) => {
            const rect = heroSection.getBoundingClientRect();
            // Normalisasi posisi mouse menjadi -1 hingga 1
            const x = (e.clientX - rect.left) / rect.width * 2 - 1;
            const y = (e.clientY - rect.top) / rect.height * 2 - 1;

            parallaxItems.forEach((item) => {
                // Ambil kedalaman dari data attribute
                const depth = parseFloat(item.getAttribute('data-depth')) || 0.1;
                const movementX = x * 20 * depth; // 20 adalah faktor sensitivitas
                const movementY = y * 20 * depth;

                gsap.to(item, {
                    x: movementX,
                    y: movementY,
                    rotation: x * 10 * depth, // Rotasi ringan
                    duration: 1.5, // Durasi smoothing
                    ease: "power2.out"
                });
            });
        });
    }

    // ------------------------
    // Work Card Scroll Animation
    // ------------------------
    gsap.utils.toArray('.work-card').forEach((card, i) => {
        gsap.from(card, {
            scrollTrigger: {
                trigger: card,
                start: "top 90%", // Mulai animasi ketika kartu masuk ke 90% view
                toggleActions: "play none none none"
            },
            y: 50,
            opacity: 0,
            duration: 0.8,
            delay: i * 0.1, // Staggering effect
            ease: ease
        });
    });

});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.frontend_app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Administrator\Downloads\RWNJ\RWNJ\resources\views/frontend/works.blade.php ENDPATH**/ ?>