<?php $__env->startPush('styles'); ?>
<style>
    /* Styling untuk tema yang baru */
    body {
        background-color: #002147;
    }

    /* Container utama */
    .collections-container {
        display: flex;
        width: 100%;
        height: 100%; /* Menggunakan viewport height penuh */
        background-color: #002147;
        color: #ffffff; /* Warna teks default */
        font-family: Arial, sans-serif;
    }

    /* Sidebar di sisi kiri */
    .collections-sidebar {
        width: 250px; /* Lebar tetap */
        background-color: #001a33; /* Warna lebih gelap untuk sidebar */
        padding: 0;
        overflow-y: auto;
        display: flex;
        flex-direction: column;
    }

    .collections-list {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .collections-list-item {
        padding: 15px 20px;
        cursor: pointer;
        transition: background-color 0.3s;
        border-bottom: 1px solid #002d5a;
        display: flex;
        align-items: center;
    }

    .collections-list-item.active {
        background-color: #003366;
        border-left: 5px solid #1a73e8; /* Indikator aktif */
    }

    .collections-list-item:hover {
        background-color: #002d5a;
    }

    .collections-list-item .item-number {
        font-size: 2rem;
        font-weight: bold;
        color: #666; /* Warna angka */
        margin-right: 15px;
    }

    .collections-list-item h4 {
        margin: 0;
        font-size: 1.1rem;
        color: #ffffff;
    }

    .collections-list-item p {
        margin: 0;
        font-size: 0.8rem;
        color: #b3b3b3;
    }

    /* Konten utama di sebelah kanan */
    .collections-content {
        flex-grow: 1;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        padding: 0px;
        position: relative;
        background-color: #002147;
    }

    .collections-3d-canvas {
        width: 100%;
        height: 100%;
    }

    /* Panel deskripsi di kanan bawah */
    .collections-detail {
        position: absolute;
        bottom: 0px;
        right: 1%;
        width: 30%; /* Lebar tetap */
        background-color: #1a1a1a;
        color: #ffffff;
        padding: 30px;
        border-radius: 10px;
        box-shadow: 0 8px 16px rgba(0, 0, 0, 0.3);
        text-align: left;
        z-index: 5;
    }

    .collections-detail h3 {
        margin-top: 0;
        font-size: 1.5rem;
        color: #ffffff;
        font-weight: bold;
    }

    /* Container untuk tahun */
    .category-container {
        position: absolute;
        top: 1%;
        left: 1%;
        z-index: 10;
    }

    .category-label {
        font-size: 200%;
        font-weight: 300;
        color: #ffffff;
    }

    .category-label strong {
        font-size: 4rem;
        font-weight: 800;
    }

    /* Container untuk judul utama */
    .title-container {
        width: 50%;
        position: absolute;
        bottom: 1%;
        left: 1%;
        z-index: 10;
    }

    .title-label {
        font-size: 300%; /* Ukuran font yang besar */
        font-weight: 700;
        color: #ffffff;
        text-transform: uppercase;
        line-height: 0.9;
    }

    .collections-detail .tabs-header {
        display: flex;
        justify-content: flex-start;
        margin-bottom: 20px;
        gap: 10px;
    }

    .collections-detail .tab-button {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        border: 2px solid #ffffff;
        background-color: transparent;
        color: #ffffff;
        font-weight: bold;
        font-size: 1.2rem;
        cursor: pointer;
        transition: background-color 0.3s, transform 0.3s;
    }

    .collections-detail .tab-button.active {
        background-color: #ffffff;
        color: #1a1a1a;
        transform: scale(1.1);
    }

    .collections-detail .tab-button:hover {
        background-color: rgba(255, 255, 255, 0.2);
    }

    .collections-detail .tab-content {
        display: none;
    }

    .collections-detail .tab-content.active {
        display: block;
    }

    .collections-detail .tab-content p {
        font-size: 1rem;
        line-height: 1.6;
        color: #cccccc;
    }

    .detail-card {
        position: absolute;
        backdrop-filter: blur(5px);
        color: #d3d3d3;
        max-width: 200px;
        box-shadow: none;
        opacity: 0;
        transition: opacity 0.5s ease-in-out;
        z-index: 4;
        text-align: center;
    }

    .detail-card.active {
        opacity: 1;
    }

    .detail-card:not(.active) {
        transform: scale(0.95);
        transition: opacity 0.5s ease-in-out, transform 0.5s ease-in-out;
    }

    .detail-card p {
        margin: 10px 0 0 0;
        font-size: 1.3rem;
        line-height: 1.4;
    }

    .detail-card img {
        max-width: 100%;
        height: auto;
        border-radius: 5px;
    }

    /* Responsif */
    @media (max-width: 1024px) {
        .collections-container {
            flex-direction: column;
        }

        .collections-sidebar {
            width: 100%;
            height: 20vh;
            border-bottom: 1px solid #002d5a;
        }

        .collections-content {
            height: 100%;
        }

        .collections-detail {
            width: 90%;
            right: 5%;
            bottom: 20px;
        }

        .category-container {
            top: 20px;
            left: 20px;
        }

        .title-container {
            bottom: 20px;
            left: 20px;
        }

        .title-label {
            font-size: 3rem;
        }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="collections-container">
    <div class="collections-sidebar">
        <ul class="collections-list">
            <?php $__currentLoopData = $collections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li class="collections-list-item" data-index="<?php echo e($index); ?>">
                <span class="item-number"><?php echo e($index + 1); ?></span>
                <div>
                    <h4><?php echo e($item['category']); ?></h4>
                    <p><?php echo e($item['title']); ?></p>
                </div>
            </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>

    <div class="collections-content">
        <div id="itemCategoryText" class="category-container">
        </div>
        <div id="itemTitleText" class="title-container">
        </div>

        <canvas class="collections-3d-canvas" id="threeJsCanvas"></canvas>

        <div id="detailPinContainer">
        </div>

        <div class="collections-detail" id="itemDetail">
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script type="importmap">
    {
        "imports": {
            "three": "https://cdn.jsdelivr.net/npm/three@0.128.0/build/three.module.js",
            "three/addons/": "https://cdn.jsdelivr.net/npm/three@0.128.0/examples/jsm/"
        }
    }
</script>
<script type="module">
    import * as THREE from 'three';
    import {
        OrbitControls
    } from 'three/addons/controls/OrbitControls.js';
    import {
        GLTFLoader
    } from 'three/addons/loaders/GLTFLoader.js';

    const collectionsData = <?php echo json_encode($collections, 15, 512) ?>;
    const colors = [0x999999, 0x1a73e8, 0xfbbc05, 0x34a853, 0xea4335, 0x5e2d8b, 0x008b8b, 0xffa500, 0x8b0000, 0x4682b4];

    let scene, camera, renderer, controls;
    let currentObject = null;
    let isTransitioning = false; // Flag untuk mencegah klik selama transisi

    const canvas = document.getElementById('threeJsCanvas');
    const itemDetail = document.getElementById('itemDetail');
    const itemCategoryText = document.getElementById('itemCategoryText');
    const itemTitleText = document.getElementById('itemTitleText');
    const detailPinContainer = document.getElementById('detailPinContainer');
    const loader = new GLTFLoader();

    function init() {
        scene = new THREE.Scene();
        scene.background = new THREE.Color(0x002147);

        camera = new THREE.PerspectiveCamera(75, window.innerWidth / window.innerHeight, 0.1, 1000);
        camera.position.z = 5;

        renderer = new THREE.WebGLRenderer({
            canvas: canvas,
            antialias: true,
            alpha: true
        });
        const parent = canvas.parentNode;
        renderer.setSize(parent.clientWidth, parent.clientHeight);
        window.addEventListener('resize', onWindowResize, false);

        controls = new OrbitControls(camera, renderer.domElement);
        controls.enableDamping = true;
        controls.dampingFactor = 0.05;
        controls.enableZoom = false;
        controls.enablePan = false;

        const ambientLight = new THREE.AmbientLight(0xffffff, 0.8);
        scene.add(ambientLight);

        const directionalLight = new THREE.DirectionalLight(0xffffff, 0.6);
        directionalLight.position.set(5, 5, 5).normalize();
        scene.add(directionalLight);
    }

    function createObject(item) {
        isTransitioning = true;
        const transitionDuration = 500;

        if (currentObject) {
            // Fade-out model lama
            const initialOpacity = currentObject.material.opacity;
            const start = performance.now();

            function fadeOut(currentTime) {
                const elapsed = currentTime - start;
                const progress = Math.min(elapsed / transitionDuration, 1);
                currentObject.material.opacity = initialOpacity * (1 - progress);

                if (progress < 1) {
                    requestAnimationFrame(fadeOut);
                } else {
                    // Hapus model lama setelah fade-out selesai
                    scene.remove(currentObject);
                    if (currentObject.geometry) currentObject.geometry.dispose();
                    if (currentObject.material) currentObject.material.dispose();
                    loadNewObject(item);
                }
            }
            requestAnimationFrame(fadeOut);
        } else {
            // Jika tidak ada model lama, langsung muat model baru
            loadNewObject(item);
        }
    }

    function loadNewObject(item) {
        if (item.model3D) {
            loader.load(
                item.model3D,
                function(gltf) {
                    currentObject = gltf.scene;
                    currentObject.traverse((child) => {
                        if (child.isMesh) {
                            child.material.transparent = true;
                            child.material.opacity = 0; // Mulai dengan opasitas 0
                        }
                    });

                    const box = new THREE.Box3().setFromObject(currentObject);
                    const size = box.getSize(new THREE.Vector3()).length();
                    const center = box.getCenter(new THREE.Vector3());

                    currentObject.position.x += (currentObject.position.x - center.x);
                    currentObject.position.y += (currentObject.position.y - center.y);
                    currentObject.position.z += (currentObject.position.z - center.z);

                    currentObject.scale.multiplyScalar(3 / size);
                    scene.add(currentObject);
                    fadeInObject();
                },
                undefined,
                function(error) {
                    console.error('An error happened while loading the model:', error);
                    createFallbackObject(item);
                }
            );
        } else {
            createFallbackObject(item);
        }
    }

    function fadeInObject() {
        const transitionDuration = 500;
        const start = performance.now();

        function fadeIn(currentTime) {
            const elapsed = currentTime - start;
            const progress = Math.min(elapsed / transitionDuration, 1);
            currentObject.traverse((child) => {
                if (child.isMesh) {
                    child.material.opacity = progress;
                }
            });

            if (progress < 1) {
                requestAnimationFrame(fadeIn);
            } else {
                currentObject.traverse((child) => {
                    if (child.isMesh) {
                        child.material.transparent = false; // Nonaktifkan transparansi setelah selesai
                    }
                });
                isTransitioning = false; // Selesai transisi
            }
        }
        requestAnimationFrame(fadeIn);
    }

    function createFallbackObject(item) {
        let geometry;
        const color = colors[Math.floor(Math.random() * colors.length)];
        const material = new THREE.MeshStandardMaterial({
            color: color,
            roughness: 0.5,
            metalness: 0.5,
            transparent: true,
            opacity: 0
        });
        geometry = new THREE.BoxGeometry(2, 2, 2);
        currentObject = new THREE.Mesh(geometry, material);
        scene.add(currentObject);
        fadeInObject();
    }


    function updateItemDetail(item) {
        let tabsHeaderHTML = '';
        let tabsContentHTML = '';
        item.description.forEach((desc, index) => {
            tabsHeaderHTML += `<button class="tab-button" data-tab-index="${index}">${index + 1}</button>`;
            tabsContentHTML += `<div class="tab-content" data-tab-index="${index}"><p>${desc.content}</p></div>`;
        });

        itemDetail.innerHTML = `
            <h3>${item.title}</h3>
            <div class="description-tabs">
                <div class="tabs-header">${tabsHeaderHTML}</div>
                <div class="tabs-content">${tabsContentHTML}</div>
            </div>
        `;

        itemCategoryText.innerHTML = `<span class="category-label">${item.category}</span>`;
        itemTitleText.innerHTML = `<span class="title-label">${item.title}</span>`;

        const firstTabButton = itemDetail.querySelector('.tab-button');
        const firstTabContent = itemDetail.querySelector('.tab-content');
        if (firstTabButton) {
            firstTabButton.classList.add('active');
            firstTabContent.classList.add('active');

            const transform = item.description[0].transform;
            if (currentObject) {
                setTimeout(() => {
                    animateTransition(transform.rotation, transform.cameraPosition);
                }, 100);
            }
            updateDetails(item.description[0].details);
        } else {
            updateDetails([]);
        }

        itemDetail.querySelectorAll('.tab-button').forEach(button => {
            button.addEventListener('click', function() {
                itemDetail.querySelectorAll('.tab-button').forEach(btn => btn.classList.remove('active'));
                itemDetail.querySelectorAll('.tab-content').forEach(content => content.classList.remove('active'));

                this.classList.add('active');
                const tabIndex = parseInt(this.dataset.tabIndex);
                itemDetail.querySelector(`.tab-content[data-tab-index="${tabIndex}"]`).classList.add('active');

                const transform = item.description[tabIndex].transform;
                const details = item.description[tabIndex].details;

                animateTransition(transform.rotation, transform.cameraPosition);
                updateDetails(details);
            });
        });
    }

    function animateTransition(targetRotation, targetCameraPosition) {
        const duration = 500;
        const start = performance.now();
        const initialRotation = currentObject ? currentObject.rotation.clone() : new THREE.Euler(0, 0, 0);
        const initialCameraPosition = camera.position.clone();

        function update(currentTime) {
            const elapsed = currentTime - start;
            const progress = Math.min(elapsed / duration, 1);

            if (currentObject) {
                currentObject.rotation.x = initialRotation.x + (targetRotation.x - initialRotation.x) * progress;
                currentObject.rotation.y = initialRotation.y + (targetRotation.y - initialRotation.y) * progress;
                currentObject.rotation.z = initialRotation.z + (targetRotation.z - initialRotation.z) * progress;
            }
            camera.position.x = initialCameraPosition.x + (targetCameraPosition.x - initialCameraPosition.x) * progress;
            camera.position.y = initialCameraPosition.y + (targetCameraPosition.y - initialCameraPosition.y) * progress;
            camera.position.z = initialCameraPosition.z + (targetCameraPosition.z - initialCameraPosition.z) * progress;

            if (progress < 1) {
                requestAnimationFrame(update);
            } else {
                controls.target.set(targetCameraPosition.x, targetCameraPosition.y, 0);
            }
        }
        requestAnimationFrame(update);
    }

    function updateDetails(details) {
        const existingCards = detailPinContainer.querySelectorAll('.detail-card');
        existingCards.forEach(card => {
            card.classList.remove('active');
            setTimeout(() => {
                if (card.parentNode) {
                    card.parentNode.removeChild(card);
                }
            }, 500);
        });

        if (details && details.length > 0) {
            setTimeout(() => {
                details.forEach(detail => {
                    const card = document.createElement('div');
                    card.className = 'detail-card';
                    card.style.left = `${detail.position.x}px`;
                    card.style.top = `${detail.position.y}px`;

                    if (detail.image) {
                        const img = document.createElement('img');
                        img.src = detail.image;
                        card.appendChild(img);
                    }

                    const p = document.createElement('p');
                    p.innerText = detail.text;
                    card.appendChild(p);

                    detailPinContainer.appendChild(card);

                    setTimeout(() => {
                        card.classList.add('active');
                    }, 10);
                });
            }, 500);
        }
    }

    document.querySelectorAll('.collections-list-item').forEach(item => {
        item.addEventListener('click', function() {
            if (isTransitioning) return; // Jangan izinkan klik saat transisi
            document.querySelectorAll('.collections-list-item').forEach(li => li.classList.remove('active'));
            this.classList.add('active');

            const index = parseInt(this.dataset.index);
            const selectedItem = collectionsData[index];
            if (selectedItem) {
                createObject(selectedItem);
                updateItemDetail(selectedItem);
            }
        });
    });

    function animate() {
        requestAnimationFrame(animate);
        controls.update();
        renderer.render(scene, camera);
    }

    function onWindowResize() {
        const parent = canvas.parentNode;
        camera.aspect = parent.clientWidth / parent.clientHeight;
        camera.updateProjectionMatrix();
        renderer.setSize(parent.clientWidth, parent.clientHeight);
    }

    init();
    animate();

    if (collectionsData.length > 0) {
        document.querySelector('.collections-list-item').click();
    }
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Administrator\Desktop\RWNJ\resources\views/collections.blade.php ENDPATH**/ ?>