<?php $__env->startPush('styles'); ?>
<link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@400;600;700&family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.min.css">

<style>
    /* ------------------------
        GLOBAL
        ------------------------ */
    :root {
        --bg: #ffffff;
        --muted: #6b7280;
        --accent: #925cff; /* Warna ungu yang elegan (mirip dengan Notes/Caffeine & Code) */
        --accent-2: #5cff92; /* Warna sekunder hijau neon untuk kontras */
        --card: #fbfbff;
        --dark-hero: #39304a; /* Background hero ungu gelap */
    }
    html, body {
        font-family: 'Quicksand', 'Poppins', sans-serif;
        background: var(--bg);
        color: #111827;
        scroll-behavior: smooth;
    }
    section { padding: 64px 20px; }
    .container { max-width: 1150px; margin: 0 auto; }
    a { color: inherit; text-decoration: none; }

    /* ------------------------
        HERO INSIGHTS (Text-Based Cover)
        ------------------------ */
    .hero-insights {
        position: relative;
        min-height: 50vh;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #fff;
        overflow: hidden;
        /* Gradien ungu yang dalam */
        background: linear-gradient(135deg, #322a4d 0%, var(--dark-hero) 100%);
        text-align: center;
    }
    .hero-insights::before {
        content: '';
        position: absolute;
        inset: 0;
        /* Tambahkan efek garis miring / noise visual */
        background-image: repeating-linear-gradient(-45deg, rgba(255,255,255,0.05), rgba(255,255,255,0.05) 1px, transparent 1px, transparent 10px);
        background-size: 15px 15px;
        opacity: 0.5;
        z-index: 1;
    }
    .hero-insights-inner { position: relative; z-index: 10; max-width: 800px; }
    .hero-insights h1 {
        margin: 0 0 10px 0;
        font-weight: 700;
        font-size: clamp(32px, 5vw, 56px);
        line-height: 1.1;
        letter-spacing: -1px;
    }
    .hero-insights p.lead {
        margin: 0;
        color: #e0e0f0;
        font-size: 1.15rem;
        max-width: 60ch;
        margin: 0 auto;
    }

    /* GSAP Animated Elements for mouse follow */
    .parallax-item {
        position: absolute;
        z-index: 5;
        pointer-events: none;
        will-change: transform;
    }
    .p-1 { top: 15%; left: 10%; width: 25px; height: 25px; background: var(--accent-2); opacity: 0.7; border-radius: 50%; filter: blur(4px); }
    .p-2 { bottom: 20%; right: 15%; width: 40px; height: 4px; background: var(--accent-2); opacity: 0.6; transform: rotate(45deg); }
    .p-3 { top: 5%; right: 5%; width: 15px; height: 15px; background: var(--accent); opacity: 0.8; border-radius: 50%; }
    .p-4 { bottom: 10%; left: 5%; width: 60px; height: 60px; border: 2px solid var(--accent); opacity: 0.3; border-radius: 50%; }


    /* ------------------------
        INSIGHTS GRID
        ------------------------ */
    .insights-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 30px;
        padding-top: 32px;
    }

    .insight-card {
        background: #fff;
        border-radius: 14px;
        box-shadow: 0 10px 25px rgba(25,30,45,0.05);
        border: 1px solid rgba(10,8,20,0.04);
        overflow: hidden;
        display: flex;
        flex-direction: column;
        transition: transform .3s ease, box-shadow .3s ease;
    }

    .insight-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 18px 40px rgba(146,92,255,0.15);
    }

    /* Cover Teks Dinamis (Menggantikan Image Cover) */
    .card-cover-text {
        height: 180px;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 20px;
        text-align: center;
        background: var(--bg); /* Default background putih */
        color: #333; /* Default text dark */
        overflow: hidden;
        border-bottom: 1px solid #f0f0f0;
        transition: background-color 0.3s ease, color 0.3s ease;
    }

    .insight-card:hover .card-cover-text {
        background-color: var(--accent); /* Warna background card menjadi ungu saat hover */
        color: #fff; /* Warna teks menjadi putih saat hover */
    }

    .card-cover-text h3 {
        margin: 0;
        font-size: clamp(1.2rem, 3vw, 1.8rem);
        line-height: 1.2;
        font-weight: 700;
        /* Efek teks tebal seperti gambar storytelling */
        text-shadow: 2px 2px 0 rgba(0,0,0,0.1);
    }

    .card-content {
        padding: 20px;
        flex-grow: 1;
        position: relative;
    }
    .card-content h4 {
        margin: 0 0 10px 0;
        font-size: 0.85rem;
        color: var(--accent);
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 1px;
    }
    .card-content p {
        color: var(--muted);
        font-size: 0.95rem;
        margin-bottom: 20px;
        /* Membatasi ringkasan */
        display: -webkit-box;
        -webkit-line-clamp: 4;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }
    .card-keyword {
        font-size: 0.75rem;
        font-weight: 600;
        padding: 4px 8px;
        border-radius: 8px;
        background: rgba(146,92,255,0.08);
        color: var(--accent);
        display: inline-block;
        margin-top: 10px;
    }

    /* Button Ikon Detail */
    .btn-detail {
        position: absolute;
        bottom: 15px;
        right: 15px;
        width: 38px;
        height: 38px;
        display: flex;
        align-items: center;
        justify-content: center;
        background: var(--accent);
        color: #fff;
        border-radius: 50%;
        font-size: 1.1rem;
        box-shadow: 0 4px 12px rgba(146,92,255,0.4);
        transition: transform 0.2s ease, background 0.2s ease;
    }
    .insight-card:hover .btn-detail {
        transform: rotate(10deg) scale(1.1);
        background: var(--accent-2);
    }

    /* Responsive */
    @media (max-width: 768px) {
        .hero-insights { min-height: 35vh; }
        .insights-grid { grid-template-columns: 1fr; }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<main class="site-main">

    
    <section class="hero-insights" aria-label="Insights, musings, and reflections">
        <div class="hero-insights-inner">
            <h1 id="heroTitle">Evening Musings & Insights</h1>
            <p class="lead" id="heroSubtitle">Thoughts on design, tech trends, philosophy, and the messy process of creation. Grab a coffee and reflect with me.</p>
        </div>

        
        <div class="parallax-item p-1" data-depth="0.1"></div>
        <div class="parallax-item p-2" data-depth="0.25"></div>
        <div class="parallax-item p-3" data-depth="0.15"></div>
        <div class="parallax-item p-4" data-depth="0.3"></div>
    </section>

    
    <section id="insights-list" class="container" aria-label="List of insights and articles">

        <?php if($insights->isEmpty()): ?>
            <div style="text-align:center; padding: 40px; color:var(--muted);">
                <i class="bi bi-lightbulb" style="font-size: 3rem; color: var(--accent);"></i>
                <h3 style="margin-top:10px;">Still drafting...</h3>
                <p>No published insights yet. Check back soon for new reflections!</p>
            </div>
        <?php else: ?>
            <div class="insights-grid">
                <?php $__currentLoopData = $insights; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="insight-card">
                        
                        <div class="card-cover-text" style="<?php echo e($insight->color ? 'background-color: ' . $insight->color . '; color: #fff; box-shadow: 0 4px 10px rgba(0,0,0,0.2);' : ''); ?>">
                            <h3 style="<?php echo e($insight->color ? 'text-shadow: none;' : ''); ?>"><?php echo e($insight->title); ?></h3>
                        </div>

                        
                        <div class="card-content">
                            <h4><?php echo e($insight->keyword ?? 'Reflection'); ?></h4>
                            <p><?php echo e($insight->summary); ?></p>

                            
                            <span class="card-keyword"><?php echo e($insight->keyword ?? 'General'); ?></span>

                            
                            <a href="#" class="btn-detail" aria-label="Read full insight">
                                <i class="bi bi-book"></i>
                            </a>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    </section>

</main>
<?php if (isset($component)) { $__componentOriginale940ec5eeeccd956e4aae389c52fb078 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale940ec5eeeccd956e4aae389c52fb078 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.floating-ctas','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('floating-ctas'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale940ec5eeeccd956e4aae389c52fb078)): ?>
<?php $attributes = $__attributesOriginale940ec5eeeccd956e4aae389c52fb078; ?>
<?php unset($__attributesOriginale940ec5eeeccd956e4aae389c52fb078); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale940ec5eeeccd956e4aae389c52fb078)): ?>
<?php $component = $__componentOriginale940ec5eeeccd956e4aae389c52fb078; ?>
<?php unset($__componentOriginale940ec5eeeccd956e4aae389c52fb078); ?>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/ScrollTrigger.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    gsap.registerPlugin(ScrollTrigger);
    const ease = "power3.out";

    // ------------------------
    // Hero Entrance Animation (Initial Load)
    // ------------------------
    gsap.from("#heroTitle", { y: 20, opacity: 0, duration: 1.2, ease: ease });
    gsap.from("#heroSubtitle", { y: 10, opacity: 0, duration: 1, delay: 0.15, ease: ease });

    gsap.from(".parallax-item", { scale: 0.5, opacity: 0, duration: 1.5, stagger: 0.1, ease: "elastic.out(1, 0.7)" });

    // ------------------------
    // Mouse Parallax Effect (Interactive GSAP Hero)
    // ------------------------
    const heroSection = document.querySelector('.hero-insights');
    const parallaxItems = gsap.utils.toArray('.parallax-item');

    if (heroSection && parallaxItems.length > 0) {
        heroSection.addEventListener('mousemove', (e) => {
            const rect = heroSection.getBoundingClientRect();
            const x = (e.clientX - rect.left) / rect.width * 2 - 1;
            const y = (e.clientY - rect.top) / rect.height * 2 - 1;

            parallaxItems.forEach((item) => {
                const depth = parseFloat(item.getAttribute('data-depth')) || 0.1;
                const movementX = x * 20 * depth;
                const movementY = y * 20 * depth;

                gsap.to(item, {
                    x: movementX,
                    y: movementY,
                    rotation: x * 10 * depth,
                    duration: 1.5,
                    ease: "power2.out"
                });
            });
        });
    }

    // ------------------------
    // Insight Card Scroll Animation
    // ------------------------
    gsap.utils.toArray('.insight-card').forEach((card, i) => {
        gsap.from(card, {
            scrollTrigger: {
                trigger: card,
                start: "top 90%",
                toggleActions: "play none none none"
            },
            y: 50,
            opacity: 0,
            duration: 0.8,
            delay: i * 0.1,
            ease: ease
        });
    });

});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.frontend_app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\rahma\Downloads\RWNJ\RWNJ\resources\views/frontend/insights.blade.php ENDPATH**/ ?>