<?php
    $isFooter = false;
?>

<?php $__env->startPush('styles'); ?>
<style>
    /* Import font bulat dan lucu */
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&family=Quicksand:wght@400;600&display=swap');

    html, body {
        height: 100%;
        margin: 0;
        padding: 0;
        overflow: hidden;
    }

    body {
        display: flex;
        flex-direction: column;
        background-color: #F4F3FF; /* Ungu pastel sangat lembut */
        font-family: 'Quicksand', 'Poppins', sans-serif;
        color: #2E2A3B; /* Warna teks gelap lembut */
    }

    .collections-container {
        display: flex;
        flex-grow: 1;
        width: 100%;
    }

    .collections-sidebar {
        width: 250px;
        background-color: #E8E6FF; /* Ungu muda pastel */
        padding: 0;
        overflow-y: auto;
        display: flex;
        flex-direction: column;
        box-shadow: 4px 0 15px rgba(150, 130, 200, 0.2);
    }

    .collections-list {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .collections-list-item {
        padding: 15px 20px;
        cursor: pointer;
        transition: background-color 0.3s, border-left 0.3s;
        border-bottom: 1px solid #DAD6F8;
        display: flex;
        align-items: center;
        position: relative;
    }

    .collections-list-item.active {
        background-color: #F9CFE0; /* Pink pastel untuk aktif */
        border-left: 5px solid #A18AFF; /* Aksen ungu pastel */
    }

    .collections-list-item:hover {
        background-color: #E1E0FF; /* Hover biru muda pastel */
    }

    .collections-list-item .item-number {
        font-size: 2rem;
        font-weight: bold;
        color: #B2A4D4;
        margin-right: 15px;
    }

    .collections-list-item h4 {
        margin: 0;
        font-size: 1.1rem;
        color: #2E2A3B;
    }

    .collections-list-item p {
        margin: 0;
        font-size: 0.8rem;
        color: #6F6993;
    }

    .collections-content {
        flex-grow: 1;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        padding: 0;
        position: relative;
        background-color: #DCEBFF; /* Biru pastel lembut untuk canvas container */
        overflow: hidden;
    }

    .collections-3d-canvas {
        width: 100%;
        height: 100%;
    }

    .collections-detail {
        position: absolute;
        bottom: 20px;
        right: 20px;
        width: 30%;
        background-color: rgba(255, 255, 255, 0.7);
        color: #2E2A3B;
        padding: 30px;
        border-radius: 15px;
        box-shadow: 0 8px 30px rgba(150, 130, 200, 0.2);
        text-align: left;
        z-index: 5;
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.3);
    }

    .collections-detail h3 {
        margin-top: 0;
        font-size: 1.5rem;
        color: #A18AFF; /* Ungu pastel */
        font-weight: bold;
    }

    .category-container {
        position: absolute;
        top: 20px;
        left: 20px;
        z-index: 10;
    }

    .category-label {
        font-size: 200%;
        font-weight: 500;
        color: #A18AFF; /* Ungu pastel */
    }

    .category-label strong {
        font-size: 4rem;
        font-weight: 800;
        color: #2E2A3B;
    }

    .title-container {
        width: 50%;
        position: absolute;
        bottom: 20px;
        left: 20px;
        z-index: 10;
    }

    .title-label {
        font-size: 300%;
        font-weight: 700;
        color: #2E2A3B;
        text-transform: uppercase;
        line-height: 0.9;
    }

    .collections-detail .tabs-header {
        display: flex;
        justify-content: flex-start;
        margin-bottom: 20px;
        gap: 10px;
    }

    .collections-detail .tab-button {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        border: 2px solid #A18AFF;
        background-color: transparent;
        color: #A18AFF;
        font-weight: bold;
        font-size: 1.2rem;
        cursor: pointer;
        transition: background-color 0.3s, transform 0.3s, color 0.3s;
    }

    .collections-detail .tab-button.active {
        background-color: #A18AFF;
        color: #FFFFFF;
        transform: scale(1.1);
    }

    .collections-detail .tab-button:hover {
        background-color: #F9CFE0; /* Pink pastel hover */
        color: #2E2A3B;
    }

    .collections-detail .tab-content {
        display: none;
    }

    .collections-detail .tab-content.active {
        display: block;
    }

    .collections-detail .tab-content p {
        font-size: 1rem;
        line-height: 1.6;
        color: #5C5470;
    }

    .detail-card {
        position: absolute;
        backdrop-filter: blur(5px);
        color: #4B4453;
        background: rgba(255, 255, 255, 0.6);
        border-radius: 10px;
        max-width: 200px;
        box-shadow: none;
        opacity: 0;
        transition: opacity 0.5s ease-in-out;
        z-index: 4;
        text-align: center;
    }

    .detail-card.active {
        opacity: 1;
    }

    .detail-card p {
        margin: 10px 0 0 0;
        font-size: 1.1rem;
        line-height: 1.4;
    }

    .detail-card img {
        max-width: 100%;
        height: auto;
        border-radius: 5px;
    }
    

    @media (max-width: 1024px) {
        .collections-container {
            flex-direction: column;
            min-height: 100vh;
        }

        .collections-sidebar {
            width: 100%;
            height: auto;
            max-height: 50vh;
            border-bottom: 1px solid #DAD6F8;
        }

        .collections-content {
            height: 100%;
        }

        .collections-detail {
            width: 90%;
            right: 5%;
            bottom: 20px;
        }

        .title-label {
            font-size: 3rem;
        }
    }
</style>
<?php $__env->stopPush(); ?>


<?php $__env->startSection('content'); ?>


<div class="collections-container">
    <div class="collections-sidebar">
        <div class="sidebar-header">
            <h3><?php echo e(ucwords($category)); ?> Pieces</h3>
        </div>
        
        <ul class="collections-list">
            <?php $__currentLoopData = $pieces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li class="collections-list-item" data-index="<?php echo e($index); ?>">
                <span class="item-number"><?php echo e($index + 1); ?></span>
                <div>
                    <h4><?php echo e($item['title']); ?></h4> 
                </div>
            </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>

    <div class="collections-content">
        <div id="itemCategoryText" class="category-container">
        </div>
        <div id="itemTitleText" class="title-container">
        </div>

        <canvas class="collections-3d-canvas" id="threeJsCanvas"></canvas>

        <div id="detailPinContainer">
        </div>

        <div class="collections-detail" id="itemDetail">
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script type="importmap">
    {
        "imports": {
            "three": "https://cdn.jsdelivr.net/npm/three@0.128.0/build/three.module.js",
            "three/addons/": "https://cdn.jsdelivr.net/npm/three@0.128.0/examples/jsm/"
        }
    }
</script>
<script type="module">
    import * as THREE from 'three';
    import { OrbitControls } from 'three/addons/controls/OrbitControls.js';
    import { GLTFLoader } from 'three/addons/loaders/GLTFLoader.js';

    const collectionsData = <?php echo json_encode($pieces, 15, 512) ?>;
    const colors = [0x999999, 0x1a73e8, 0xfbbc05, 0x34a853, 0xea4335, 0x5e2d8b, 0x008b8b, 0xffa500, 0x8b0000, 0x4682b4];

    let scene, camera, renderer, controls;
    let currentObject = null;
    let isTransitioning = false;
    let currentItemIndex = -1;

    const collectionsContainer = document.querySelector('.collections-container');
    const canvas = document.getElementById('threeJsCanvas');
    const itemDetail = document.getElementById('itemDetail');
    const itemCategoryText = document.getElementById('itemCategoryText');
    const itemTitleText = document.getElementById('itemTitleText');
    const detailPinContainer = document.getElementById('detailPinContainer');
    const loader = new GLTFLoader();

    function init() {
        scene = new THREE.Scene();
        scene.background = new THREE.Color(0xA8C5FF);

        camera = new THREE.PerspectiveCamera(75, window.innerWidth / window.innerHeight, 0.1, 1000);
        camera.position.z = 5;

        renderer = new THREE.WebGLRenderer({
            canvas: canvas,
            antialias: true,
            alpha: true
        });

        onWindowResize();
        window.addEventListener('resize', onWindowResize, false);

        controls = new OrbitControls(camera, renderer.domElement);
        controls.enableDamping = true;
        controls.dampingFactor = 0.05;
        controls.enableZoom = false;
        controls.enablePan = false;

        const ambientLight = new THREE.AmbientLight(0xffffff, 0.8);
        scene.add(ambientLight);

        const directionalLight = new THREE.DirectionalLight(0xffffff, 0.6);
        directionalLight.position.set(5, 5, 5).normalize();
        scene.add(directionalLight);
    }

    function createObject(item) {
        isTransitioning = true;

        if (currentObject) {
            const initialOpacity = 1;
            const transitionDuration = 500;
            const start = performance.now();

            function fadeOut(currentTime) {
                const elapsed = currentTime - start;
                const progress = Math.min(elapsed / transitionDuration, 1);

                currentObject.traverse((child) => {
                    if (child.isMesh && child.material) {
                        child.material.opacity = initialOpacity * (1 - progress);
                    }
                });

                if (progress < 1) {
                    requestAnimationFrame(fadeOut);
                } else {
                    scene.remove(currentObject);
                    currentObject.traverse((child) => {
                        if (child.isMesh) {
                            if (child.geometry) child.geometry.dispose();
                            if (child.material) child.material.dispose();
                        }
                    });

                    currentObject = null;
                    loadNewObject(item);
                }
            }
            requestAnimationFrame(fadeOut);
        } else {
            loadNewObject(item);
        }
    }

    function loadNewObject(item) {
        const modelPath = '<?php echo e(asset('assets/chibi_dokibird.glb')); ?>';

        loader.load(
            modelPath,
            function(gltf) {
                currentObject = gltf.scene;

                currentObject.traverse((child) => {
                    if (child.isMesh && child.material) {
                        child.material.transparent = true;
                        child.material.opacity = 0;
                    }
                });

                const box = new THREE.Box3().setFromObject(currentObject);
                const size = box.getSize(new THREE.Vector3()).length();
                const center = box.getCenter(new THREE.Vector3());

                currentObject.position.x += (currentObject.position.x - center.x);
                currentObject.position.y += (currentObject.position.y - center.y);
                currentObject.position.z += (currentObject.position.z - center.z);
                currentObject.scale.multiplyScalar(3 / size);

                // --- PERUBAHAN 1: Atur rotasi awal sebelum objek ditampilkan ---
                // Ini memastikan model langsung muncul di pose yang benar
                if (item.description && item.description.length > 0) {
                    const initialRotation = item.description[0].transform.rotation;
                    currentObject.rotation.set(initialRotation.x, initialRotation.y, initialRotation.z);
                }

                scene.add(currentObject);
                fadeInObject();
            },
            undefined,
            function(error) {
                console.error('An error happened while loading the model:', error);
                createFallbackObject(item);
            }
        );
    }

    function fadeInObject() {
        const transitionDuration = 500;
        const start = performance.now();

        function fadeIn(currentTime) {
            const elapsed = currentTime - start;
            const progress = Math.min(elapsed / transitionDuration, 1);
            currentObject.traverse((child) => {
                if (child.isMesh && child.material) {
                    child.material.opacity = progress;
                }
            });

            if (progress < 1) {
                requestAnimationFrame(fadeIn);
            } else {
                currentObject.traverse((child) => {
                    if (child.isMesh && child.material) {
                         // Biarkan transparent agar transisi fadeOut berfungsi
                    }
                });
                isTransitioning = false;
            }
        }
        requestAnimationFrame(fadeIn);
    }

    function createFallbackObject(item) {
        const color = colors[Math.floor(Math.random() * colors.length)];
        const material = new THREE.MeshStandardMaterial({
            color: color,
            roughness: 0.5,
            metalness: 0.5,
            transparent: true,
            opacity: 0
        });
        const geometry = new THREE.BoxGeometry(2, 2, 2);
        currentObject = new THREE.Mesh(geometry, material);
        scene.add(currentObject);
        fadeInObject();
    }

    function updateItemDetail(item) {
        let tabsHeaderHTML = '';
        let tabsContentHTML = '';
        item.description.forEach((desc, index) => {
            tabsHeaderHTML += `<button class="tab-button" data-tab-index="${index}">${index + 1}</button>`;
            tabsContentHTML += `<div class="tab-content" data-tab-index="${index}"><p>${desc.content}</p></div>`;
        });

        itemDetail.innerHTML = `
            <h3>${item.title}</h3>
            <div class="description-tabs">
                <div class="tabs-header">${tabsHeaderHTML}</div>
                <div class="tabs-content">${tabsContentHTML}</div>
            </div>
        `;

        itemCategoryText.innerHTML = `<span class="category-label">${item.category}</span>`;
        itemTitleText.innerHTML = `<span class="title-label">${item.title}</span>`;

        const firstTabButton = itemDetail.querySelector('.tab-button');
        const firstTabContent = itemDetail.querySelector('.tab-content');
        if (firstTabButton) {
            firstTabButton.classList.add('active');
            firstTabContent.classList.add('active');

            // Tidak perlu memanggil animateTransition di sini karena rotasi awal sudah diatur
            // di loadNewObject. Cukup update detail pin saja.
            updateDetails(item.description[0].details);
        } else {
            updateDetails([]);
        }

        itemDetail.querySelectorAll('.tab-button').forEach(button => {
            button.addEventListener('click', function() {
                // --- PERUBAHAN 2: Reset kontrol kamera saat tab diklik ---
                // Ini mengembalikan view ke posisi default sebelum animasi
                if (controls) controls.reset();

                itemDetail.querySelectorAll('.tab-button').forEach(btn => btn.classList.remove('active'));
                itemDetail.querySelectorAll('.tab-content').forEach(content => content.classList.remove('active'));

                this.classList.add('active');
                const tabIndex = parseInt(this.dataset.tabIndex);
                itemDetail.querySelector(`.tab-content[data-tab-index="${tabIndex}"]`).classList.add('active');

                const transform = item.description[tabIndex].transform;
                const details = item.description[tabIndex].details;

                animateTransition(transform.rotation);
                updateDetails(details);
            });
        });
    }

    function animateTransition(targetRotation) {
        if (!currentObject) return;

        const duration = 500;
        const start = performance.now();
        const initialRotation = currentObject.rotation.clone();

        function update(currentTime) {
            const elapsed = currentTime - start;
            const progress = Math.min(elapsed / duration, 1);
            const easedProgress = 1 - Math.pow(1 - progress, 3);

            currentObject.rotation.x = initialRotation.x + (targetRotation.x - initialRotation.x) * easedProgress;
            currentObject.rotation.y = initialRotation.y + (targetRotation.y - initialRotation.y) * easedProgress;
            currentObject.rotation.z = initialRotation.z + (targetRotation.z - initialRotation.z) * easedProgress;

            if (progress < 1) {
                requestAnimationFrame(update);
            }
        }
        requestAnimationFrame(update);
    }

    function updateDetails(details) {
        const existingCards = detailPinContainer.querySelectorAll('.detail-card');
        existingCards.forEach(card => {
            card.classList.remove('active');
            setTimeout(() => {
                if (card.parentNode) {
                    card.parentNode.removeChild(card);
                }
            }, 500);
        });

        if (details && details.length > 0) {
            setTimeout(() => {
                details.forEach(detail => {
                    const card = document.createElement('div');
                    card.className = 'detail-card';
                    card.style.left = `${detail.position.x}px`;
                    card.style.top = `${detail.position.y}px`;

                    if (detail.image) {
                        const img = document.createElement('img');
                        img.src = detail.image;
                        card.appendChild(img);
                    }

                    const p = document.createElement('p');
                    p.innerText = detail.text;
                    card.appendChild(p);

                    detailPinContainer.appendChild(card);

                    setTimeout(() => {
                        card.classList.add('active');
                    }, 10);
                });
            }, 500);
        }
    }

    document.querySelectorAll('.collections-list-item').forEach(item => {
        item.addEventListener('click', function() {
            if (isTransitioning) return;
            const newIndex = parseInt(this.dataset.index);

            if (newIndex === currentItemIndex) {
                return;
            }

            // --- PERUBAHAN 3: Reset kontrol kamera saat item baru di sidebar diklik ---
            if (controls) controls.reset();

            document.querySelectorAll('.collections-list-item').forEach(li => li.classList.remove('active'));
            this.classList.add('active');

            const selectedItem = collectionsData[newIndex];
            if (selectedItem) {
                createObject(selectedItem);
                updateItemDetail(selectedItem);
                currentItemIndex = newIndex;
            }
        });
    });

    function animate() {
        requestAnimationFrame(animate);
        controls.update();
        renderer.render(scene, camera);
    }

    function setContainerHeight() {
        const header = document.querySelector('.navbar');
        if (header) {
            const headerHeight = header.offsetHeight;
            collectionsContainer.style.height = (window.innerHeight - headerHeight) + 'px';
        } else {
            collectionsContainer.style.height = window.innerHeight + 'px';
        }

        const parent = canvas.parentNode;
        camera.aspect = parent.clientWidth / parent.clientHeight;
        camera.updateProjectionMatrix();
        renderer.setSize(parent.clientWidth, parent.clientHeight);
    }

    function onWindowResize() {
        setContainerHeight();
    }

    init();
    animate();

    if (collectionsData.length > 0) {
        document.querySelector('.collections-list-item').click();
    }
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.frontend_app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Administrator\Downloads\RWNJ\RWNJ\resources\views/frontend/pieces/view.blade.php ENDPATH**/ ?>