<style>
    /* CSS Khusus untuk Header/Navbar */
    :root {
        --main-text-color: #333;
        --navbar-bg-color: #fff;
        --navbar-border-color: #eee;
        --primary-accent: #E91E63; /* Pink */
        --secondary-accent: #00BCD4; /* Cyan/Mint */
    }

    .navbar {
        background-color: var(--navbar-bg-color);
        border-bottom: 1px solid var(--navbar-border-color);
        transition: all 0.3s ease;
    }
    .navbar-brand img {
        height: 40px;
    }
    .nav-link {
        color: var(--main-text-color) !important;
        font-weight: bold;
        position: relative;
        transition: all 0.3s ease;
    }
    .nav-link::after {
        content: '';
        position: absolute;
        bottom: -5px;
        left: 0;
        width: 0;
        height: 3px;
        background-color: var(--secondary-accent);
        transition: width 0.3s ease;
    }
    .nav-link:hover::after,
    .nav-link.active::after {
        width: 100%;
    }
    .offcanvas {
        background-color: var(--navbar-bg-color);
        color: var(--main-text-color);
    }
    .offcanvas-body .nav-link {
        color: var(--main-text-color) !important;
        padding: 10px;
    }
    .offcanvas-body .nav-link:hover {
        background-color: var(--navbar-border-color);
        color: var(--primary-accent) !important;
    }
    .offcanvas .btn-close {
        filter: invert(0);
    }
    .navbar-toggler-icon {
        filter: none;
    }
</style>

<nav id="mainNavbar" class="navbar navbar-expand-lg fixed-top">
    <div class="container-fluid">
        <a class="navbar-brand" href="#">
            <img src="https://static.vecteezy.com/system/resources/previews/020/448/322/non_2x/rnj-letter-logo-design-in-illustration-logo-calligraphy-designs-for-logo-poster-invitation-etc-vector.jpg" alt="Logo RNJ">
        </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasNavbar" aria-controls="offcanvasNavbar">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasNavbar" aria-labelledby="offcanvasNavbarLabel">
            <div class="offcanvas-header">
                <h5 class="offcanvas-title" id="offcanvasNavbarLabel">Menu</h5>
                <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
            </div>
            <div class="offcanvas-body">
                <ul class="navbar-nav justify-content-end flex-grow-1 pe-3">
                    <li class="nav-item">
                        <a class="nav-link active" aria-current="page" href="#">Canvas</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">Projects</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">Lab</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">Offerings</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">Thoughts</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">Collection</a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</nav>
<?php /**PATH C:\Users\Administrator\Desktop\RWNJ\resources\views/layouts/header.blade.php ENDPATH**/ ?>