<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['name', 'initialMedia' => []]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['name', 'initialMedia' => []]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .media-preview-area {
        display: flex;
        flex-direction: column;
        gap: 15px;
    }
    .media-row {
        min-height: 120px;
        border: 2px dashed #ccc;
        border-radius: 8px;
        padding: 10px;
        background-color: #f8f9fa;
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
        align-items: center;
        position: relative;
    }
    .media-row:empty::before {
        content: 'Drag media here or add a new one.';
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        color: #999;
    }
    .media-item {
        position: relative;
        height: 100px; /* Tinggi tetap, lebar menyesuaikan */
        border: 1px solid #ddd;
        border-radius: 4px;
        overflow: hidden;
        cursor: grab;
    }
    .media-item img, .media-item video {
        height: 100%;
        width: auto; /* Lebar menyesuaikan */
        object-fit: contain; /* Hindari pemotongan, jaga rasio aspek */
    }
    .media-item .remove-btn {
        position: absolute;
        top: 5px;
        right: 5px;
        background: rgba(0,0,0,0.5);
        color: white;
        border: none;
        border-radius: 50%;
        width: 25px;
        height: 25px;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
    }
    /* Style untuk tombol Delete Row yang baru */
    .row-actions-container {
        position: absolute;
        top: 5px;
        left: 5px;
        display: flex;
        gap: 5px;
        z-index: 10; /* Pastikan di atas item media */
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sortablejs@1.14.0/Sortable.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const mediaArea = document.getElementById('media-preview-area');
        const hiddenOrderInput = document.getElementById('media_order_data');
        const hiddenDeletedInput = document.getElementById('deleted_media_ids');
        let deletedIds = [];
        let fileCounter = 0;

        // Fungsi untuk membuat elemen pratinjau media
        function createMediaItem(file, isExisting = false, mediaId = null) {
            const tempId = 'new_' + fileCounter++;
            const item = document.createElement('div');
            item.classList.add('media-item');
            item.dataset.id = isExisting ? mediaId : tempId;

            const removeBtn = document.createElement('button');
            removeBtn.classList.add('remove-btn');
            removeBtn.innerHTML = '&times;';
            removeBtn.setAttribute('type', 'button');
            removeBtn.addEventListener('click', () => {
                if (isExisting) {
                    deletedIds.push(mediaId);
                    hiddenDeletedInput.value = deletedIds.join(',');
                }
                item.remove();
                updateMediaOrder();
            });

            if (file.type && file.type.startsWith('video')) {
                const video = document.createElement('video');
                video.src = URL.createObjectURL(file);
                video.controls = true;
                item.appendChild(video);
            } else {
                const img = document.createElement('img');
                img.src = URL.createObjectURL(file);
                item.appendChild(img);
            }

            item.appendChild(removeBtn);
            return item;
        }

        // Fungsi untuk membuat input file tersembunyi
        function createHiddenFileInput(file) {
            const dataTransfer = new DataTransfer();
            dataTransfer.items.add(file);
            const input = document.createElement('input');
            input.type = 'file';
            input.name = '<?php echo e($name); ?>[]';
            input.files = dataTransfer.files;
            input.classList.add('d-none', 'new-media-input');
            return input;
        }

        // Fungsi untuk memperbarui urutan media di hidden input
        function updateMediaOrder() {
            const order = [];
            document.querySelectorAll('.media-row').forEach((row, rowIndex) => {
                row.querySelectorAll('.media-item').forEach((item, itemIndex) => {
                    const id = item.dataset.id;
                    const isNew = id.startsWith('new_');
                    order.push({
                        id: isNew ? id : parseInt(id),
                        is_new: isNew,
                        row: rowIndex,
                        order: itemIndex
                    });
                });
            });
            hiddenOrderInput.value = JSON.stringify(order);
        }

        // Fungsi untuk menginisialisasi SortableJS
        function initSortableRows() {
            document.querySelectorAll('.media-row').forEach(row => {
                new Sortable(row, {
                    group: 'media',
                    animation: 150,
                    onEnd: updateMediaOrder
                });
            });
        }

        // Fungsi untuk membuat baris media baru
        function createNewRow() {
            const newRowContainer = document.createElement('div');
            newRowContainer.classList.add('media-row-container'); // Tambahkan container untuk baris

            // Tambahkan tombol delete row
            const removeRowBtn = document.createElement('button');
            removeRowBtn.classList.add('btn', 'btn-danger', 'btn-sm', 'delete-row-btn');
            removeRowBtn.textContent = 'Delete Row';
            removeRowBtn.setAttribute('type', 'button');
            removeRowBtn.addEventListener('click', () => {
                if (confirm('Are you sure you want to delete this row and all its media?')) {
                    newRow.querySelectorAll('.media-item').forEach(item => {
                        const mediaId = item.dataset.id;
                        if (!mediaId.startsWith('new_')) {
                            deletedIds.push(mediaId);
                        }
                    });
                    hiddenDeletedInput.value = deletedIds.join(',');
                    newRowContainer.remove(); // Hapus container, bukan hanya baris
                    updateMediaOrder();
                }
            });

            // Tambahkan elemen baris media
            const newRow = document.createElement('div');
            newRow.classList.add('media-row');

            // Gabungkan tombol dan baris di dalam container
            newRowContainer.appendChild(removeRowBtn);
            newRowContainer.appendChild(newRow);

            mediaArea.appendChild(newRowContainer);
            initSortableRows();
            return newRow;
        }

        // Tampilkan media yang sudah ada berdasarkan data JSON
        const initialMedia = <?php echo json_encode($initialMedia, 15, 512) ?>;
        if (initialMedia.length > 0) {
            const rows = {};
            initialMedia.sort((a, b) => (a.details?.row ?? 0) - (b.details?.row ?? 0) || (a.details?.order ?? 0) - (b.details?.order ?? 0));

            initialMedia.forEach(media => {
                const rowIndex = media.details?.row ?? 0;
                if (!rows[rowIndex]) {
                    rows[rowIndex] = createNewRow();
                }
                const item = document.createElement('div');
                item.classList.add('media-item');
                item.dataset.id = media.id;

                if (media.file_type.startsWith('image')) {
                    const img = document.createElement('img');
                    img.src = `<?php echo e(Storage::url('')); ?>/${media.file_path}`;
                    item.appendChild(img);
                } else if (media.file_type.startsWith('video')) {
                    const video = document.createElement('video');
                    const source = document.createElement('source');
                    source.src = `<?php echo e(Storage::url('')); ?>/${media.file_path}`;
                    source.type = media.file_type;
                    video.appendChild(source);
                    video.controls = true;
                    item.appendChild(video);
                }

                const removeBtn = document.createElement('button');
                removeBtn.classList.add('remove-btn');
                removeBtn.innerHTML = '&times;';
                removeBtn.setAttribute('type', 'button');
                removeBtn.addEventListener('click', () => {
                    deletedIds.push(media.id);
                    hiddenDeletedInput.value = deletedIds.join(',');
                    item.remove();
                    updateMediaOrder();
                });
                item.appendChild(removeBtn);
                rows[rowIndex].appendChild(item);
            });
        } else {
            createNewRow();
        }

        initSortableRows();

        // Event listener untuk tombol "Add Media"
        document.getElementById('add-media-btn').addEventListener('click', () => {
            const input = document.createElement('input');
            input.type = 'file';
            input.name = 'temp_file_input';
            input.multiple = true;
            input.classList.add('d-none');

            input.addEventListener('change', (e) => {
                const files = e.target.files;
                const lastRowContainer = mediaArea.lastElementChild;
                const lastRow = lastRowContainer.querySelector('.media-row');
                for (const file of files) {
                    const item = createMediaItem(file);
                    const hiddenInput = createHiddenFileInput(file);
                    item.appendChild(hiddenInput);
                    lastRow.appendChild(item);
                }
                updateMediaOrder();
            });
            input.click();
        });

        // Event listener untuk tombol "Add Row"
        document.getElementById('add-row-btn').addEventListener('click', createNewRow);

        updateMediaOrder(); // Inisialisasi urutan saat halaman dimuat
    });
</script>
<?php $__env->stopPush(); ?>

<div class="media-uploader-container">
    <label class="form-label">Upload Media (Images, Videos, GIFs)</label>
    <div id="media-preview-area" class="media-preview-area">
        
    </div>
    <div class="d-flex gap-2 mt-3">
        <button type="button" id="add-media-btn" class="btn btn-secondary">
            <i class="ti ti-plus"></i> Add Media
        </button>
        <button type="button" id="add-row-btn" class="btn btn-outline-secondary">
            Add New Row
        </button>
    </div>
    <input type="hidden" name="deleted_media_ids" id="deleted_media_ids">
    <input type="hidden" name="media_order_data" id="media_order_data">
</div>
<?php /**PATH C:\Users\Administrator\Desktop\RWNJ\resources\views/components/media-uploader.blade.php ENDPATH**/ ?>