@extends('layouts.frontend_app')

@push('styles')
<link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@400;600;700&family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.min.css">

<style>
    /* ------------------------
        GLOBAL
        ------------------------ */
    :root {
        --bg: #ffffff;
        --muted: #6b7280;
        --accent: #7c5cff; /* Ungu Asli */
        --accent-dark-hover: #6a4bdb; /* Ungu Lebih Gelap untuk Hover */
        --accent-2: #ff7ab6;
        --card: #fbfbff;
        --dark-hero: #0b1020;
        --glass: rgba(255,255,255,0.85);
        --social-link-color: #374151; /* Warna teks untuk link sosial */
    }

    html, body {
        height: 100%;
        margin: 0;
        font-family: 'Quicksand', 'Poppins', sans-serif;
        background: var(--bg);
        color: #111827;
        scroll-behavior: smooth;
    }

    a { color: inherit; text-decoration: none; }
    img { max-width: 100%; display:block; }

    main.site-main {
        width: 100%;
        min-height: calc(100vh - 80px);
        box-sizing: border-box;
    }

    section { padding: 64px 20px; }
    .container { max-width: 1150px; margin: 0 auto; }

    /* ------------------------
        HERO
        ------------------------ */
    .hero {
        position: relative;
        min-height: 72vh;
        display:flex;
        align-items:center;
        justify-content:center;
        color: #fff;
        overflow: hidden;
        background: var(--dark-hero);
    }

    #particles-js {
        position: absolute;
        inset:0;
        z-index:0;
        pointer-events: auto;
    }

    .hero-inner { position: relative; z-index:5; width:100%; }
    .hero-grid {
        display:grid;
        grid-template-columns: 1fr 420px;
        gap: 32px;
        align-items:center;
    }

    .hero-left h1 {
        margin:0 0 12px 0;
        font-weight:700;
        font-size: clamp(28px, 4.2vw, 44px);
        line-height: 1.02;
        letter-spacing: -0.6px;
        color: #fff;
    }

    .hero-left p.lead { margin:0 0 22px 0; color:#d1d5db; font-size:1.05rem; max-width:58ch; }
    .hero-ctas { display:flex; gap:12px; align-items:center; }

    /* MODIFIKASI: Ganti animasi geser dengan perubahan warna saat hover */
    .btn-primary-hero {
        display:inline-flex;
        align-items:center;
        gap:10px;
        padding:12px 18px;
        background-color: var(--accent); /* Menggunakan warna accent */
        color: #fff;
        border-radius:12px;
        box-shadow: 0 10px 30px rgba(124,92,255,0.12);
        font-weight:700;
        /* Transisi hanya untuk background dan shadow */
        transition: background-color 0.3s ease, box-shadow 0.3s ease;
    }

    .btn-primary-hero:hover {
        /* Ganti dengan warna ungu yang sedikit lebih gelap */
        background-color: var(--accent-dark-hover);

        /* Pertahankan efek bayangan sedikit naik */
        box-shadow: 0 14px 35px rgba(215, 13, 251, 0.2);

        /* Hapus transform: translateY(-2px); */
    }

    /* Hapus .slide-text-wrapper karena tidak diperlukan lagi */
    /* .btn-primary-hero .slide-text-wrapper {
        display: inline-flex;
        align-items: center;
    } */

    .btn-ghost {
        background: transparent;
        border: 1px solid rgba(255,255,255,0.12);
        color: #fff;
        padding: 10px 16px;
        border-radius: 12px;
        transition: background 0.2s ease, border-color 0.2s ease;
    }
    .btn-ghost:hover {
        background: rgba(255,255,255,0.1);
        border-color: rgba(255,255,255,0.2);
    }

    .hero-right {
        display:flex;
        align-items:center;
        justify-content:center;
        position: relative;
        /* Menyesuaikan ukuran untuk Model Viewer */
        height: 380px;
    }
    .hero-right .canvas-wrapper {
        width: 420px;
        height: 380px;
        max-width: 100%;
        background-color: transparent;
    }

    /* Tambahkan style untuk model-viewer */
    model-viewer {
        width: 100%;
        height: 100%;
        /* Opsi: tambahkan background agar model lebih terlihat */
        --poster-color: transparent;
        border-radius: 12px; /* Sesuaikan dengan desain Anda */
    }


    /* ------------------------
        ABOUT
        ------------------------ */
    .about {
        background: var(--card);
        border-radius: 12px;
        box-shadow: 0 10px 30px rgba(16,24,40,0.04);
        padding: 28px;
        display:grid;
        grid-template-columns: 360px 1fr;
        gap: 28px;
        align-items: center;
    }

    .about-left {
        /* Tambahkan efek Glassmorphism */
        padding: 12px;
        background: rgba(255, 255, 255, 0.4); /* Transparan */
        border-radius: 16px;
        box-shadow: 0 8px 30px rgba(16,24,40,0.08);
        border: 1px solid rgba(255, 255, 255, 0.18);
        backdrop-filter: blur(8px); /* Efek Blur */
        -webkit-backdrop-filter: blur(8px);
    }
    .about-left img { border-radius: 12px; display:block; width:100%; height:auto; object-fit:cover; border: 4px solid var(--card); }
    .about-left p { margin-top: 10px; text-align: center; font-weight: 700; color: #111827; }

    .about-right h3 { margin:0 0 12px 0; font-size: 1.45rem; color: var(--accent); }
    .about-right p { color: var(--muted); margin-bottom: 14px; }

    .tags { display:flex; gap:8px; flex-wrap:wrap; margin-top:12px; }
    .tag {
        padding:6px 10px;
        border-radius:999px;
        background: rgba(124,92,255,0.08);
        color: var(--accent);
        font-weight:600;
        font-size:0.85rem;
    }

    /* ------------------------
        SERVICES
        ------------------------ */
    .services-grid { display:grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap:16px; }
    .service-card {
        background: #fff;
        border-radius: 12px;
        padding: 20px;
        box-shadow: 0 8px 26px rgba(18,24,40,0.04);
        border: 1px solid rgba(10,8,20,0.02);
        transition: transform .24s ease, box-shadow .24s ease;
        display: flex;
        flex-direction: column;
    }
    .service-card:hover { transform: translateY(-8px); box-shadow: 0 20px 40px rgba(124,92,255,0.10); }

    .service-card .icon-wrapper {
        font-size: 2rem;
        color: var(--accent);
        margin-bottom: 10px;
    }
    .service-card h4 { margin:0 0 8px 0; color: #111827; font-weight: 700; }
    .service-card p { margin:0; color: var(--muted); font-size: 0.95rem; }

    /* ------------------------
        PHILOSOPHY / VIDEO (Diubah)
        ------------------------ */
    .philo-video-grid {
        display:grid;
        grid-template-columns: 1fr 320px; /* 1fr untuk quote, 320px untuk video portrait */
        gap: 28px;
        align-items:flex-start; /* Untuk menyejajarkan item di atas */
    }

    .philo-left { flex: 1.1; }

    .quote-card {
        background: #fff;
        border-radius: 12px;
        padding: 24px;
        box-shadow: 0 8px 30px rgba(16,24,40,0.04);
        margin-bottom: 20px;
    }
    .philo-quote { font-size: 1.15rem; font-weight:600; color: #111827; margin-bottom: 14px; }
    .philo-text { color: var(--muted); line-height:1.6; }

    .philo-right-menu { /* Menggantikan philo-right lama */
        background: #fff;
        border-radius: 12px;
        padding: 12px;
        box-shadow: 0 8px 30px rgba(16,24,40,0.04);
    }
    .philo-right-menu ul a { color: var(--muted); transition: color 0.2s ease; }
    .philo-right-menu ul a:hover { color: var(--accent); }
    .philo-right-menu ul a.active { color: var(--accent); font-weight: 600; }

    /* ------------------------
        VIDEO PORTRAIT
        ------------------------ */
    #video { padding-top: 0; } /* Hapus padding atas jika digabung dengan philosophy */

    .video-portrait-wrapper {
        /* Container untuk Video & Menu */
        display:flex;
        flex-direction: column;
        gap: 20px;
    }

    .video-card {
        border-radius: 12px;
        overflow:hidden;
        background: #000;
        /* Ukuran untuk Portrait: rasio 9:16 atau 3:4 */
        width: 100%;
        height: 520px; /* Tinggi yang cukup untuk portrait */
        box-shadow: 0 10px 40px rgba(10,10,30,0.1);
    }
    .video-card video {
        width:100%;
        height:100%;
        object-fit: cover; /* Pastikan video mengisi area tanpa distorsi */
        display:block;
        border:0;
    }


    /* ------------------------
        FOOTER / SOCIALS
        ------------------------ */
    footer.site-footer { padding: 36px 20px; background: #f7f7fc; border-top: 1px solid rgba(16,24,40,0.04); }

    /* Modifikasi Tampilan Socials: Tampilkan URL */
    .socials { display:flex; gap:12px; align-items:center; flex-wrap:wrap; }
    .socials a {
        display:inline-flex;
        align-items:center;
        gap:8px;
        padding:8px 12px;
        border-radius:10px;
        background:#fff;
        box-shadow:0 4px 12px rgba(10,10,30,0.04);
        color:var(--social-link-color);
        border:1px solid rgba(10,10,30,0.03);
        font-size:0.9rem;
        font-weight:600;
        transition: all 0.2s ease;
    }
    .socials a i { color: var(--accent); font-size: 1.1rem; }
    .socials a span { font-weight: 400; font-size: 0.8rem; color: var(--muted); }
    .socials a:hover { background: #f0f0f5; }


    /* ------------------------
        RESPONSIVE
        ------------------------ */
    @media (max-width: 980px) {
        .hero-grid { grid-template-columns: 1fr; }
        .about { grid-template-columns: 1fr; }
        .services-grid { grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); } /* Lebih fleksibel di tablet */

        .philo-video-grid {
            grid-template-columns: 1fr; /* Stack video dan quote di mobile */
        }
        .video-portrait-wrapper { order: -1; } /* Video di atas Quote/Menu */
        .philo-right-menu { width:100%; }
        .video-card { height: 400px; } /* Sesuaikan tinggi video portrait di mobile */
        .hero-right { height: 300px; } /* Atur tinggi hero-right di mobile */
    }
    @media (max-width: 560px) {
        .services-grid { grid-template-columns: 1fr; }
        .hero-left p.lead { max-width: 100%; }
    }

</style>
@endpush

@section('content')
<main class="site-main">

    <section class="hero" id="homeHero" aria-label="Hero section">
        <div id="particles-js" aria-hidden="true"></div>

        <div class="hero-inner container">
            <div class="hero-grid">
                <div class="hero-left">
                    <h1 id="heroTitle">Hi, I'm Rahmawati — maker, tinkerer & occasional chaos artist.</h1>
<div class="hero-ctas">
                        {{-- MODIFIKASI: Tombol "About me" menjadi "Open PDF" --}}
                        <a class="btn-primary-hero" href="{{ asset('assets/your_resume.pdf') }}" target="_blank">
                            <span class="slide-text-wrapper">
                                {{-- Mengganti ikon bi-person-circle menjadi bi-file-earmark-pdf --}}
                                <i class="bi bi-file-earmark-pdf"></i>
                                {{-- Mengganti teks --}}
                                <span>Open PDF Resume</span>
                            </span>
                        </a>

                        <a class="btn-ghost" href="#about">She</a>
                    </div>
                </div>

                <div class="hero-right">
                    <div class="canvas-wrapper">
                        {{-- MENAMPILKAN MODEL 3D GLB DENGAN GOOGLE MODEL VIEWER --}}
                        <model-viewer
                            id="chibiModel"
                            src="{{ asset('assets/chibi_baymax.glb') }}" {{-- Ganti dengan path model GLB Anda --}}
                            alt="A 3D model representing the user's work"
                            ar
                            shadow-intensity="1"
                            auto-rotate
                            disable-zoom
                            orbit="0deg 90deg 100%" {{-- Set initial orbit: 0deg azimuth, 90deg elevation (horizontal view), 100% distance --}}
                            touch-action="pan-y" {{-- Mencegah konflik dengan scrolling vertikal --}}
                        ></model-viewer>
                        {{-- End Model Viewer --}}
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section id="about" class="container" aria-label="About">
        <div class="about">
            <div class="about-left glass-card">
                {{-- Menggunakan URL Spongebob yang Anda berikan --}}
                <img src="{{ asset('assets/rahma.jpeg') }}" alt="About image">
                <p>Rahma</p>
            </div>
            <div class="about-right">
               <h3>Core & Curiosity</h3>

            {{-- MODIFIKASI DESKRIPSI (Dipendekkan) --}}
            <p>I engineer full-stack systems to manage data from the physical world, complementing this technical focus with creative experiments in interactive art, kinetic sculpture, and digital storytelling.</p>

            <div class="tags" aria-hidden="false">
                <span class="tag">Data Integration</span>
                <span class="tag">Web Engineering</span>
                <span class="tag">Interactive Media</span>
                <span class="tag">Sonic Art</span>
                <span class="tag">3D / WebGL</span>
            </div>

                <div style="margin-top:18px;">
                    <a class="btn-primary-hero" href="#video">
                        <span class="slide-text-wrapper">
                            <i class="bi bi-camera-video"></i>
                            <span>Caffeine & code</span>
                        </span>
                    </a>
                    <a class="btn-ghost" href="#services">Services</a>
                </div>
            </div>
        </div>
    </section>

    <section id="services" class="container" aria-label="Services">
        <h2 style="color:var(--accent); margin:0 0 14px 0;">Services & things I help with</h2>
        <p style="color:var(--muted); margin:0 0 20px 0;">Collaborating on things requiring hardware + software — here are common ways I work.</p>

        <div class="services-grid" role="list">
            {{-- LOOPING DATA SERVICE DARI DATABASE --}}
            @if (isset($services) && $services->isNotEmpty())
                @foreach ($services as $service)
                    <div class="service-card">
                        {{-- Icon diambil dari kolom 'icon'. Pastikan ikon menggunakan class Bootstrap Icons (bi-*) --}}
                        <div class="icon-wrapper">
                            <i class="{{ $service->icon ?? 'bi-gear' }}"></i>
                        </div>
                        <h4>{{ $service->title }}</h4>
                        <p>{{ $service->description }}</p>
                    </div>
                @endforeach
            @else
                {{-- Placeholder jika variabel $services belum didefinisikan atau kosong --}}
                <div style="color:var(--muted); grid-column: 1 / -1;">
                    <p>No services defined yet. Please add data to the 'services' table or ensure controller sends the $services variable.</p>
                </div>
            @endif
        </div>
    </section>

    <section id="philosophy" class="container" aria-label="Philosophy and Experiments">
        <div class="philo-video-grid">

            <div class="philo-left">
                <div class="quote-card">
                    <div class="philo-quote">A portfolio isn't just a highlight reel — it's a playground for ideas.</div>
                    <div class="philo-text">Each project is an experiment. Some things are sketches, small tests, or proof-of-concepts meant to provoke curiosity. If you like messy learning, you've found the right place.</div>
                    <div style="margin-top:18px;">
                        <a class="btn-primary-hero" href="{{ route('frontend.labs') }}">
                            <span class="slide-text-wrapper">
                                <i class="bi bi-lightbulb"></i>
                                <span>See experiments</span>
                            </span>
                        </a>
                    </div>
                </div>

                <div class="philo-right-menu">
                    <strong style="color:var(--accent);">Idea Sandbox</strong>
                    <ul style="padding:12px 0 0 0; list-style:none; margin:0; line-height:1.6;">
                        <li style="padding:8px 0;">
                            <a href="{{ route('frontend.works') }}">Projects I've nurtured — where code meets curiosity</a>
                        </li>
                        <li style="padding:8px 0;">
                            <a href="{{ route('frontend.labs') }}">Labs & experiments — playful tinkering in progress</a>
                        </li>
                        <li style="padding:8px 0;">
                            <a href="{{ route('frontend.services') }}" class="active">Ways I collaborate — sharing skills, crafting experiences</a>
                        </li>
                        <li style="padding:8px 0;">
                            <a href="{{ route('frontend.insights') }}">Notes & reflections — thoughts from the messy middle</a>
                        </li>
                    </ul>
                </div>
            </div>


            <div class="video-portrait-wrapper">
                <h3 style="color:var(--accent); margin-bottom:12px;">Evening musings</h3>
                <div class="video-card">
                    <video controls muted autoplay loop playsinline>
                        {{-- Ganti dengan path video Anda --}}
                        <source src="{{ asset('assets/rituals.mp4') }}" type="video/mp4">
                        Your browser does not support the video tag.
                    </video>
                </div>
            </div>

        </div>
    </section>


    <section id="connect" class="container" aria-label="Connect">
        <div style="display:flex; justify-content:space-between; align-items:center; gap:16px; flex-wrap:wrap;">
            <div>
                <h3 style="margin:0 0 6px 0; color:var(--accent);">Let's connect</h3>
                <p style="margin:0; color:var(--muted);">I share experiments, notes, and behind-the-scenes on socials.</p>
                <div style="height:12px;"></div>

                <div class="socials" aria-hidden="false">
                    {{-- START: LOOP DATA SOSIAL MEDIA DARI DATABASE (VARIABLE $links) --}}
                    @if (isset($links) && $links->isNotEmpty())
                        @foreach ($links->sortBy('order') as $link)
                            <a href="{{ $link->url }}" target="_blank" rel="noopener">
                                {{-- Ikon diambil dari kolom 'icon' --}}
                                <i class="bi {{ $link->icon ?? 'bi-link' }}"></i>
                                {{-- Nama platform/link diambil dari kolom 'name' --}}
                                {{ $link->name }}
                                {{-- Ekstra: Tampilkan domain URL atau username jika ingin menampilkan detail --}}
                                @php
                                    // Ambil bagian path URL untuk ditampilkan sebagai "username"
                                    $path = parse_url($link->url, PHP_URL_PATH);
                                    // Hapus slash di awal dan akhir
                                    $cleanPath = trim($path, '/');
                                @endphp
                                @if ($cleanPath)
                                    <span>/{{ $cleanPath }}</span>
                                @endif
                            </a>
                        @endforeach
                    @else
                        {{-- Tampilkan placeholder jika data kosong atau tidak terkirim --}}
                        <p style="color:var(--muted); font-size: 0.9rem;">
                            No social links defined yet. Please add data to the 'links' table.
                        </p>
                    @endif
                    {{-- END: LOOP DATA SOSIAL MEDIA --}}
                </div>
            </div>
            <div>
                <a class="btn-primary-hero" href="mailto:{{ config('mail.from.address') ?? 'hello@example.com' }}">
                    <span class="slide-text-wrapper">
                        <i class="bi bi-envelope"></i>
                        <span>Email me</span>
                    </span>
                </a>
            </div>
        </div>
    </section>

</main>

{{-- Memanggil komponen CTA --}}
<x-floating-ctas />


@endsection

@push('scripts')
{{-- Model Viewer Library --}}
<script type="module" src="https://ajax.googleapis.com/ajax/libs/model-viewer/3.4.0/model-viewer.min.js"></script>

<script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/ScrollTrigger.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/ScrollToPlugin.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // ------------------------
    // particles.js config
    // ------------------------
    if (window.particlesJS) {
        particlesJS('particles-js', {
            "particles": {
                "number": { "value": 48, "density": { "enable": true, "value_area": 900 } },
                "color": { "value": ["#7c5cff", "#ff7ab6", "#ffffff"] },
                "shape": { "type": "circle" },
                "opacity": { "value": 0.7, "random": true },
                "size": { "value": 4, "random": true },
                "line_linked": { "enable": true, "distance": 140, "color": "#7c5cff", "opacity": 0.12, "width": 1 },
                "move": { "enable": true, "speed": 2.2, "direction": "none", "out_mode": "out" }
            },
            "interactivity": {
                "detect_on": "canvas",
                "events": { "onhover": { "enable": true, "mode": "repulse" }, "onclick": { "enable": true, "mode": "push" }, "resize": true },
                "modes": { "repulse": { "distance": 140, "duration": 0.6 }, "push": { "particles_nb": 4 } }
            },
            "retina_detect": true
        });
    }

    // ------------------------
    // GSAP entrance animations
    // ------------------------
    gsap.registerPlugin(ScrollTrigger, ScrollToPlugin);
    const ease = "power3.out";
    gsap.from("#heroTitle", { y: 18, opacity:0, duration:0.9, ease });
    gsap.from("#heroSubtitle", { y:12, opacity:0, duration:1, delay:0.12, ease });
    // Animasi untuk model 3D (opsional, Model Viewer umumnya memuat dengan baik)
    gsap.from(".canvas-wrapper model-viewer", { scale:0.98, opacity:0, duration:1.1, delay:0.18, ease:"elastic.out(1,0.6)" });

    // Animasi untuk Service Cards
    gsap.utils.toArray('.service-card').forEach((card,i)=>{
        gsap.from(card,{
            scrollTrigger:{trigger:card,start:"top 85%"},
            y:30,
            opacity:0,
            duration:0.8,
            delay:i*0.06,
            ease
        });
    });

    gsap.from('.about-left', { scrollTrigger:{trigger:'.about',start:"top 80%"}, x:-30, opacity:0, duration:0.9, ease });
    gsap.from('.about-right', { scrollTrigger:{trigger:'.about',start:"top 80%"}, x:30, opacity:0, duration:0.9, ease });
    gsap.from('.philo-video-grid', { scrollTrigger:{trigger:'.philo-video-grid',start:"top 80%"}, opacity:0, duration:0.9, ease });


    // ------------------------
    // GSAP CTA button hover animation (Slide Text)
    // ------------------------
    gsap.utils.toArray('.btn-primary-hero').forEach(btn => {
        const textSpan = btn.querySelector('.slide-text-wrapper span');
        const icon = btn.querySelector('.slide-text-wrapper i');

        // Initial state
        gsap.set(textSpan, { x: 0 });

        btn.addEventListener('mouseenter', () => {
            gsap.to(textSpan, { x: 5, duration: 0.3, ease: 'power2.out' }); // Slide teks sedikit ke kanan
            gsap.to(icon, { x: -3, duration: 0.3, ease: 'power2.out' }); // Slide ikon sedikit ke kiri
        });

        btn.addEventListener('mouseleave', () => {
            gsap.to(textSpan, { x: 0, duration: 0.3, ease: 'power2.out' }); // Kembali ke posisi awal
            gsap.to(icon, { x: 0, duration: 0.3, ease: 'power2.out' }); // Kembali ke posisi awal
        });
    });

    // ------------------------
    // Custom 3D Model Mouse Rotation (Horizontal Only)
    // ------------------------
    const modelViewer = document.getElementById('chibiModel');
    const heroSection = document.getElementById('homeHero');

    if (modelViewer && heroSection) {
        // Initial rotation orbit
        let initialOrbit = modelViewer.getAttribute('orbit');
        let initialAzimuth = parseFloat(initialOrbit.split(' ')[0]);

        heroSection.addEventListener('mousemove', (e) => {
            // Get boundaries and dimensions of the hero section
            const rect = heroSection.getBoundingClientRect();

            // Calculate mouse position relative to the hero section (0 to 1)
            const x = (e.clientX - rect.left) / rect.width;

            // Map mouse X position (0 to 1) to a rotation range (e.g., -20 degrees to +20 degrees)
            // Range is relative to the initial rotation (0deg in orbit="0deg 90deg 100%")
            // We'll use a total swing of 40 degrees (from -20 to +20)
            const rotationRange = 40;
            const offsetAzimuth = (x * rotationRange) - (rotationRange / 2); // Result: -20 to +20

            // New azimuth is the initial azimuth plus the offset
            const newAzimuth = initialAzimuth + offsetAzimuth;

            // Set the new orbit, keeping elevation (90deg) and distance (100%) constant
            // Use a smooth transition
            gsap.to(modelViewer, {
                '--model-viewer-orbit-azimuth': `${newAzimuth}deg`,
                duration: 0.8,
                ease: "power2.out",
                onUpdate: () => {
                    // Manually update the orbit attribute to reflect the GSAP tween,
                    // otherwise model-viewer might not recognize the change or reset it.
                    // Note: GSAP can't directly tween the orbit attribute string, so we use CSS properties.
                    // This is a common workaround for `model-viewer`.
                    modelViewer.setAttribute('orbit', `${newAzimuth}deg 90deg 100%`);
                }
            });
        });

        // Optional: Reset/Stop rotation on mouse leave if needed
        heroSection.addEventListener('mouseleave', () => {
             // Return to auto-rotate, or a neutral position, or just let the last position hold
             // Setting auto-rotate again:
             if (!modelViewer.hasAttribute('auto-rotate')) {
               modelViewer.setAttribute('auto-rotate', '');
             }
             gsap.to(modelViewer, {
                '--model-viewer-orbit-azimuth': `${initialAzimuth}deg`,
                duration: 2,
                ease: "power2.inOut",
                onUpdate: () => {
                    modelViewer.setAttribute('orbit', `${initialAzimuth}deg 90deg 100%`);
                }
            });
        });

        // Disable touch control on the model viewer explicitly if it's causing unwanted rotation on mobile
        // By removing camera-controls, we already handled it, but this adds more constraint.
        modelViewer.addEventListener('touchmove', (e) => e.preventDefault());
    }

    // ------------------------
    // Scroll to Top shortcut
    // ------------------------
    document.addEventListener('keydown', (e)=>{ if(e.key==='t'){ gsap.to(window,{scrollTo:0,duration:0.9,ease:"power2.inOut"}); } });

    // ------------------------
    // Hide particles on small devices
    // ------------------------
    function adaptParticles(){
        const el=document.getElementById('particles-js');
        if(!el) return;
        el.style.display=(window.innerWidth<560)?'none':'block';
    }
    adaptParticles();
    window.addEventListener('resize', adaptParticles);
});
</script>
@endpush
