@extends('layouts.frontend_app')

@push('styles')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.min.css">
<style>
    /* Variabel Warna */
    :root {
        --main-bg-color: #f8f8f8;
        --main-text-color: #333;
        --card-bg-color: #fff;
        --card-border-color: #eee;
        --primary-accent: #E91E63; /* Pink */
        --secondary-accent: #00BCD4; /* Cyan/Mint */
    }

    body {
        background-color: var(--main-bg-color);
        color: var(--main-text-color);
    }

    .hero-section {
        background-color: var(--main-bg-color);
        padding: 5rem 0;
        text-align: center;
    }
    .hero-section h1 {
        font-weight: bold;
    }

    .service-section {
        padding: 2rem 0;
    }

    /* Gaya untuk Accordion */
    .accordion-item {
        border: none;
        background-color: transparent;
        margin-bottom: 1rem;
    }
    .accordion-header .accordion-button {
        background-color: var(--card-bg-color);
        color: var(--main-text-color);
        font-weight: bold;
        padding: 1.5rem;
        border-radius: 10px;
        box-shadow: 0 4px 8px rgba(0,0,0,0.05);
        border: 1px solid var(--card-border-color);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    .accordion-header .accordion-button:not(.collapsed) {
        color: var(--primary-accent); /* Warna teks saat terbuka */
        background-color: var(--card-bg-color);
        box-shadow: 0 4px 16px rgba(0,0,0,0.1);
    }
    .accordion-header .accordion-button:focus {
        box-shadow: none;
        border-color: var(--primary-accent);
    }
    .accordion-button::after {
        display: none; /* Sembunyikan ikon panah default */
    }

    .accordion-body {
        background-color: var(--card-bg-color);
        border-radius: 0 0 10px 10px;
        padding: 1.5rem;
        border: 1px solid var(--card-border-color);
        border-top: none;
    }

    .service-icon {
        color: var(--primary-accent);
        font-size: 1.5rem;
        margin-right: 1.5rem;
    }

    /* Garis bawah di judul yang memanjang saat di-hover/aktif */
    .service-title {
        position: relative;
        padding-bottom: 10px;
        font-size: 1.25rem;
    }
    .service-title::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        width: 40px;
        height: 3px;
        background-color: var(--secondary-accent);
        border-radius: 2px;
        transition: width 0.3s ease;
    }
    .accordion-button:hover .service-title::after,
    .accordion-button:not(.collapsed) .service-title::after {
        width: 100%;
    }
</style>
@endpush

@section('content')
    <div class="hero-section animated-gradient-banner">
        <div class="container">
            <h1>What I Offer</h1>
            <p class="lead">
                I help brands and individuals to tell their stories and visualize complex ideas
                through a blend of technology and creativity.
            </p>
        </div>
    </div>

    <div class="container-fluid my-5 ">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="accordion" id="serviceAccordion">
                    @foreach ($services as $service)
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="heading-{{ $service['id'] }}">
                            <button class="accordion-button collapsed d-flex align-items-center" type="button" data-bs-toggle="collapse" data-bs-target="#{{ 'collapse' . $service['id'] }}" aria-expanded="false" aria-controls="{{ 'collapse' . $service['id'] }}">
                                <i class="bi {{ $service['icon'] }} service-icon"></i>
                                <span class="service-title">{{ $service['title'] }}</span>
                            </button>
                        </h2>
                        <div id="{{ 'collapse' . $service['id'] }}" class="accordion-collapse collapse" aria-labelledby="heading-{{ 'collapse' . $service['id'] }}" data-bs-parent="#serviceAccordion">
                            <div class="accordion-body">
                                <p class="text-muted">{{ $service['description'] }}</p>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
@endpush
