@extends('layouts.frontend_app')

@section('title', '3D Archives | Computational Musings')

@push('styles')
{{-- Menggunakan font yang sama dengan welcome page --}}
<link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@400;600;700&family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.min.css">

<style>
    /* -------------------------------------
       CSS VARIABLES (Diselaraskan dengan welcome page)
       ------------------------------------- */
    :root {
        --bg: #ffffff; /* Menggunakan background yang sama dengan welcome page */
        --muted: #6b7280;
        --accent: #7c5cff; /* Ungu Asli */
        --accent-dark-hover: #6a4bdb;
        --accent-2: #ff7ab6;
        --card: #fbfbff; /* Warna kartu lebih lembut */
        --text-dark: #111827; /* Dark Gray dari welcome page */
    }

    /* -------------------------------------
       GENERAL PAGE STYLES (Diselaraskan)
       ------------------------------------- */
    .category-page {
        padding: 64px 20px; /* Padding sama dengan section di welcome page */
        min-height: calc(100vh - 80px); /* Menyesuaikan tinggi main content */
        display: flex;
        flex-direction: column;
        align-items: center;
        background-color: var(--bg); /* Menggunakan variabel bg */
        font-family: 'Quicksand', 'Poppins', sans-serif; /* Font diselaraskan */
        color: var(--text-dark);
    }

    .category-header {
        text-align: center;
        margin-bottom: 60px;
        max-width: 800px;
    }

    .category-header h1 {
        /* Menggunakan font size yang agresif seperti di hero welcome page */
        font-size: clamp(28px, 4.2vw, 44px);
        font-weight: 700;
        color: var(--accent); /* Menggunakan variabel accent */
        margin-bottom: 12px;
        line-height: 1.05;
        letter-spacing: -0.6px;
    }

    .category-header p {
        font-size: 1.05rem;
        color: var(--muted); /* Menggunakan variabel muted */
        font-weight: 400; /* Font weight disesuaikan */
        max-width: 60ch;
        margin: 0 auto;
    }

    /* -------------------------------------
       CARD STYLES (Diselaraskan)
       ------------------------------------- */
    .category-list {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        gap: 24px; /* Gap disesuaikan */
        max-width: 1150px; /* Max width sama dengan container di welcome page */
        width: 100%;
    }

    .category-card {
        background-color: var(--card); /* Menggunakan variabel card */
        border-radius: 12px; /* Radius diselaraskan */
        /* Shadow diselaraskan dengan service-card: 0 8px 26px rgba(18,24,40,0.04) */
        box-shadow: 0 8px 26px rgba(18,24,40,0.04);
        transition: transform .24s ease, box-shadow .24s ease;
        text-decoration: none;
        color: inherit;
        width: 250px; /* Ukuran lebih ringkas */
        padding: 24px;
        text-align: center;
        border: 1px solid rgba(10,8,20,0.02); /* Border halus */
        display: flex;
        flex-direction: column;
        align-items: center;
    }

    .category-card:hover {
        transform: translateY(-8px); /* Efek hover diselaraskan */
        /* Shadow lebih kuat saat hover diselaraskan: 0 20px 40px rgba(124,92,255,0.10) */
        box-shadow: 0 20px 40px rgba(124,92,255,0.10);
        border-color: var(--accent); /* Memberikan aksen border saat hover */
    }

    .category-card h2 {
        margin: 10px 0 4px 0;
        font-size: 1.3rem;
        color: var(--text-dark);
        font-weight: 700;
    }

    .category-icon {
        font-size: 2.2rem; /* Ukuran ikon sedikit lebih kecil */
        color: var(--accent);
        /* Background ikon diselaraskan */
        background: rgba(124, 92, 255, 0.08);
        padding: 12px;
        border-radius: 50%;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        min-width: 50px;
        min-height: 50px;
    }

    .category-card small {
        margin-top: 6px;
        color: var(--muted);
        font-size: 0.85rem;
        font-weight: 500;
    }

    /* Media queries tetap */
    @media (max-width: 768px) {
        .category-header h1 {
            font-size: 2.2rem;
        }
        .category-list {
            gap: 20px;
        }
        .category-card {
            width: 95%;
            max-width: 350px;
        }
    }
</style>
@endpush

@section('content')
<div class="category-page">
    <div class="category-header">
        {{-- GAYA BAHASA: Lebih metaforis dan sesuai tone --}}
        <h1>Archive of Explorations: Geometry & Bits 👾</h1>
        <p>A structured index of my computational musings and modeled curiosities. This is where concepts are deconstructed into raw geometry and interactive experiments.</p>
    </div>

    <div class="category-list">
        @forelse($categories as $category)
            @php
                $categorySlug = \Illuminate\Support\Str::slug($category);

                // Mapping ikon menggunakan Bootstrap Icons (bi-*) untuk konsistensi visual
                $iconClass = 'bi-box-seam'; // Default
                switch (strtolower($category)) {
                    case 'kata benda':
                        $iconClass = 'bi-book';
                        break;
                    case 'hewan':
                        $iconClass = 'bi-bug';
                        break;
                    case 'tumbuhan':
                        $iconClass = 'bi-tree';
                        break;
                    case 'transportasi':
                        $iconClass = 'bi-truck';
                        break;
                    case 'geometri':
                        $iconClass = 'bi-cone';
                        break;
                    case 'arsitektur':
                        $iconClass = 'bi-building';
                        break;
                }
            @endphp

            <a href="{{ route('frontend.pieces.show_by_category', ['category' => $categorySlug]) }}" class="category-card">
                <span class="category-icon">
                    <i class="bi {{ $iconClass }}"></i>
                </span>
                <h2>{{ $category }}</h2>
                {{-- GAYA BAHASA: Mengganti Explore the Geometry --}}
                <small>View the Conceptual Mesh</small>
            </a>
        @empty
            <div style="text-align: center; padding: 50px; color: var(--muted);">
                <h2>The Archive is Quiet.</h2>
                <p>No categorised 3D pieces found. Please populate the `pieces` table to activate this exploration module.</p>
            </div>
        @endforelse
    </div>
</div>
@endsection
