@extends('layouts.backend_app')

@section('title', 'Services Management')

@push('styles')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
@endpush

@section('content')
    <div class="container-fluid">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h5 class="card-title fw-semibold">Services Management</h5>
                    <a href="{{ route('backend.services.create') }}" class="btn btn-primary">
                        <i class="ti ti-plus"></i> Add New Service
                    </a>
                </div>

                @if (session('success'))
                    <div class="alert alert-success" role="alert">
                        {{ session('success') }}
                    </div>
                @endif
                @if (session('error'))
                    <div class="alert alert-danger" role="alert">
                        {{ session('error') }}
                    </div>
                @endif

                <div class="card">
                    <div class="card-body p-4">
                        <div class="table-responsive">
                            <table class="table text-nowrap mb-0 align-middle">
                                <thead class="text-dark fs-4">
                                    <tr>
                                        <th class="border-bottom-0" style="width: 5%;">
                                            <h6 class="fw-semibold mb-0">No</h6>
                                        </th>
                                        <th class="border-bottom-0" style="width: 15%;">
                                            <h6 class="fw-semibold mb-0">Icon</h6>
                                        </th>
                                        <th class="border-bottom-0" style="width: 25%;">
                                            <h6 class="fw-semibold mb-0">Title</h6>
                                        </th>
                                        <th class="border-bottom-0" style="width: 40%;">
                                            <h6 class="fw-semibold mb-0">Description</h6>
                                        </th>
                                        <th class="border-bottom-0" style="width: 15%;">
                                            <h6 class="fw-semibold mb-0">Actions</h6>
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($services as $index => $service)
                                        <tr>
                                            <td class="border-bottom-0">
                                                <h6 class="fw-semibold mb-0">{{ $index + 1 }}</h6>
                                            </td>
                                            <td class="border-bottom-0">
                                                <i class="bi {{ $service->icon }}" style="font-size: 1.5rem;"></i>
                                            </td>
                                            <td class="border-bottom-0">
                                                <h6 class="fw-semibold mb-0">{{ $service->title }}</h6>
                                            </td>
                                            <td class="border-bottom-0">
                                                <p class="mb-0 fw-normal">{{ Str::limit($service->description, 100) }}</p>
                                            </td>
                                            <td class="border-bottom-0">
                                                <div class="d-flex justify-content-start gap-2">
                                                    <a href="{{ route('backend.services.edit', $service->id) }}"
                                                        class="btn btn-sm btn-primary">
                                                        Edit
                                                    </a>
                                                    <form action="{{ route('backend.services.destroy', $service->id) }}"
                                                        method="POST"
                                                        onsubmit="return confirm('Are you sure you want to delete this service?');"
                                                        style="display:inline;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-sm btn-danger">
                                                            Delete
                                                        </button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                @if ($services->isEmpty())
                    <p class="text-center mt-4">No services found.</p>
                @endif
            </div>
        </div>
    </div>
@endsection
