@extends('layouts.backend_app')

@section('title', 'Edit Service')

@push('styles')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        .icon-preview {
            font-size: 2rem;
            margin-top: 5px;
            min-width: 50px;
            text-align: center;
        }
    </style>
@endpush

@section('content')
    <div class="container-fluid">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title fw-semibold mb-4">Edit Service: {{ $service->title }}</h5>
                <div class="card">
                    <div class="card-body">
                        <form action="{{ route('backend.services.update', $service->id) }}" method="POST">
                            @csrf
                            @method('PUT')

                            <div class="mb-3">
                                <label for="title" class="form-label">Service Title</label>
                                <input type="text" name="title" id="title"
                                    class="form-control @error('title') is-invalid @enderror"
                                    value="{{ old('title', $service->title) }}" required>
                                @error('title')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="description" class="form-label">Description</label>
                                <textarea name="description" id="description" rows="4"
                                    class="form-control @error('description') is-invalid @enderror" required>{{ old('description', $service->description) }}</textarea>
                                @error('description')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="icon" class="form-label">Icon Class (e.g., bi-code-slash)</label>
                                <div class="d-flex align-items-center gap-3">
                                    <input type="text" name="icon" id="icon"
                                        class="form-control @error('icon') is-invalid @enderror"
                                        value="{{ old('icon', $service->icon) }}"
                                        placeholder="Contoh: bi-code-slash, bi-phone, bi-palette">
                                    <div id="icon-preview" class="icon-preview">
                                        {{-- Konten preview akan diisi oleh JavaScript --}}
                                    </div>
                                </div>
                                @error('icon')
                                    <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">Gunakan nama kelas dari Bootstrap Icons.</small>
                            </div>

                            <button type="submit" class="btn btn-primary">Update Service</button>
                            <a href="{{ route('backend.services.index') }}"
                                class="btn btn-outline-secondary ms-2">Cancel</a>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const iconInput = document.getElementById('icon');
            const iconPreview = document.getElementById('icon-preview');

            function updateIconPreview() {
                const iconClass = iconInput.value.trim();
                iconPreview.innerHTML = '';

                if (iconClass) {
                    const iconElement = document.createElement('i');
                    // Pastikan prefix 'bi-' ada
                    iconElement.className = iconClass.startsWith('bi-') ? 'bi ' + iconClass : 'bi bi-' + iconClass;
                    iconPreview.appendChild(iconElement);
                } else {
                    iconPreview.innerHTML = '<i class="bi bi-question-square"></i>';
                }
            }

            updateIconPreview();
            iconInput.addEventListener('input', updateIconPreview);
        });
    </script>
@endpush
