@extends('layouts.backend_app')

@section('title', 'Pieces Management')

@section('content')
    <div class="container-fluid">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h5 class="card-title fw-semibold">Pieces Management</h5>
                    {{-- Link to the create page --}}
                    <a href="{{ route('backend.pieces.create') }}" class="btn btn-primary">
                        <i class="ti ti-plus"></i> Create New Piece
                    </a>
                </div>

                {{-- Success Message Display --}}
                @if (session('success'))
                    <div class="alert alert-success" role="alert">
                        {{ session('success') }}
                    </div>
                @endif

                <div class="card">
                    <div class="card-body p-4">
                        <div class="table-responsive">
                            {{-- The $pieces variable is assumed to be passed from the controller's index method --}}
                            <table class="table text-nowrap mb-0 align-middle">
                                <thead class="text-dark fs-4">
                                    <tr>
                                        <th class="border-bottom-0">
                                            <h6 class="fw-semibold mb-0">Title</h6>
                                        </th>
                                        <th class="border-bottom-0">
                                            <h6 class="fw-semibold mb-0">Category</h6>
                                        </th>
                                        <th class="border-bottom-0">
                                            <h6 class="fw-semibold mb-0">3D Model</h6>
                                        </th>

                                        <th class="border-bottom-0">
                                            <h6 class="fw-semibold mb-0">Actions</h6>
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($pieces as $piece)
                                        <tr>
                                            <td class="border-bottom-0">
                                                <h6 class="fw-semibold mb-0">{{ $piece->title }}</h6>
                                            </td>
                                            <td class="border-bottom-0">
                                                <span
                                                    class="badge bg-secondary rounded-3 fw-semibold">{{ $piece->category }}</span>
                                            </td>
                                            <td class="border-bottom-0">
                                                <p class="mb-0 fw-normal">{{ $piece->model3d ?? 'N/A' }}</p>
                                            </td>

                                            <td class="border-bottom-0">
                                                <div class="d-flex justify-content-start gap-2">
                                                    {{-- Edit Button --}}
                                                    <a href="{{ route('backend.pieces.edit', $piece->id) }}"
                                                        class="btn btn-sm btn-primary">
                                                        Edit
                                                    </a>
                                                    {{-- Delete Form --}}
                                                    <form action="{{ route('backend.pieces.destroy', $piece->id) }}"
                                                        method="POST"
                                                        onsubmit="return confirm('Are you sure you want to delete this piece?');"
                                                        style="display:inline;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-sm btn-danger">
                                                            Delete
                                                        </button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
