@extends('layouts.backend_app')

@section('title', 'Create New Link')

@push('styles')
    {{-- Asumsi Anda menggunakan Bootstrap Icons. Jika tidak, ganti dengan library ikon yang Anda gunakan. --}}
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        .icon-preview {
            font-size: 2rem;
            margin-top: 5px;
            min-width: 50px;
            /* Memastikan ada ruang untuk ikon */
            text-align: center;
        }
    </style>
@endpush

@section('content')
    <div class="container-fluid">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title fw-semibold mb-4">Create New Link</h5>
                <div class="card">
                    <div class="card-body">
                        <form action="{{ route('backend.links.store') }}" method="POST">
                            @csrf

                            <div class="mb-3">
                                <label for="name" class="form-label">Platform Name (e.g., GitHub, LinkedIn)</label>
                                <input type="text" name="name" id="name"
                                    class="form-control @error('name') is-invalid @enderror" value="{{ old('name') }}"
                                    required>
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="url" class="form-label">URL</label>
                                <input type="url" name="url" id="url"
                                    class="form-control @error('url') is-invalid @enderror" value="{{ old('url') }}"
                                    required>
                                @error('url')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="icon" class="form-label">Icon Class (e.g., bi-github)</label>
                                <div class="d-flex align-items-center gap-3">
                                    <input type="text" name="icon" id="icon"
                                        class="form-control @error('icon') is-invalid @enderror" value="{{ old('icon') }}"
                                        placeholder="Contoh: bi-github, bi-instagram">
                                    <div id="icon-preview" class="icon-preview">
                                        <i class="bi bi-question-square"></i>
                                    </div>
                                </div>
                                @error('icon')
                                    <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">Gunakan nama kelas dari Bootstrap Icons.</small>
                            </div>

                            <div class="mb-3">
                                <label for="order" class="form-label">Order</label>
                                <input type="number" name="order" id="order"
                                    class="form-control @error('order') is-invalid @enderror" value="{{ old('order', 0) }}">
                                @error('order')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <button type="submit" class="btn btn-primary">Save Link</button>
                            <a href="{{ route('backend.links.index') }}" class="btn btn-outline-secondary ms-2">Cancel</a>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const iconInput = document.getElementById('icon');
            const iconPreview = document.getElementById('icon-preview');

            function updateIconPreview() {
                const iconClass = iconInput.value.trim();
                iconPreview.innerHTML = ''; // Kosongkan preview

                if (iconClass) {
                    // Tambahkan elemen <i> baru dengan kelas ikon yang dimasukkan pengguna
                    const iconElement = document.createElement('i');
                    iconElement.className = 'bi ' + iconClass;
                    iconPreview.appendChild(iconElement);
                } else {
                    // Tampilkan ikon default jika input kosong
                    iconPreview.innerHTML = '<i class="bi bi-question-square"></i>';
                }
            }

            // Jalankan saat halaman dimuat
            updateIconPreview();

            // Jalankan setiap kali input berubah
            iconInput.addEventListener('input', updateIconPreview);
        });
    </script>
@endpush
