@extends('layouts.backend_app')

@section('title', 'Pieces Management')

@section('content')
    <div class="container-fluid">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h5 class="card-title fw-semibold">Pieces Management (3D Collections)</h5>
                    <a href="{{ route('backend.pieces.create') }}" class="btn btn-primary">
                        <i class="ti ti-plus"></i> Create New Piece 🎨
                    </a>
                </div>

                @if (session('success'))
                    <div class="alert alert-success" role="alert">
                        {{ session('success') }}
                    </div>
                @endif

                <div class="card">
                    <div class="card-body p-4">
                        <div class="table-responsive">
                            <table class="table text-nowrap mb-0 align-middle">
                                <thead class="text-dark fs-4">
                                    <tr>
                                        <th class="border-bottom-0">
                                            <h6 class="fw-semibold mb-0">Title</h6>
                                        </th>
                                        <th class="border-bottom-0">
                                            <h6 class="fw-semibold mb-0">Category</h6>
                                        </th>
                                        <th class="border-bottom-0">
                                            <h6 class="fw-semibold mb-0">Total Sections</h6>
                                        </th>
                                        <th class="border-bottom-0">
                                            <h6 class="fw-semibold mb-0">3D Model Status</h6>
                                        </th>
                                        <th class="border-bottom-0">
                                            <h6 class="fw-semibold mb-0">Actions</h6>
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    {{-- Loop melalui data pieces yang dikirim dari controller --}}
                                    @forelse($pieces as $piece)
                                        <tr>
                                            <td class="border-bottom-0">
                                                <h6 class="fw-semibold mb-0">{{ $piece->title }}</h6>
                                            </td>
                                            <td class="border-bottom-0">
                                                <p class="mb-0 fw-normal">{{ $piece->category }}</p>
                                            </td>
                                            <td class="border-bottom-0">
                                                {{-- Menghitung jumlah objek/sections di dalam array description --}}
                                                @php
                                                    // Karena kolom 'description' di-cast sebagai array di Model,
                                                    // kita bisa menggunakan count() langsung
                                                    $sectionCount = is_array($piece->description)
                                                        ? count($piece->description)
                                                        : 0;
                                                @endphp
                                                <span class="badge bg-info rounded-3 fw-semibold">{{ $sectionCount }}
                                                    Section(s)</span>
                                            </td>
                                            <td class="border-bottom-0">
                                                {{-- Menampilkan status model 3D --}}
                                                @if ($piece->model3d)
                                                    <span class="badge bg-success rounded-3 fw-semibold">Uploaded</span>
                                                @else
                                                    <span class="badge bg-warning rounded-3 fw-semibold">Missing</span>
                                                @endif
                                            </td>
                                            <td class="border-bottom-0">
                                                <div class="d-flex justify-content-start gap-2">
                                                    {{-- Tombol Edit --}}
                                                    <a href="{{ route('backend.pieces.edit', $piece->id) }}"
                                                        class="btn btn-sm btn-primary">
                                                        Edit
                                                    </a>
                                                    {{-- Tombol Delete --}}
                                                    <form action="{{ route('backend.pieces.destroy', $piece->id) }}"
                                                        method="POST"
                                                        onsubmit="return confirm('Are you sure you want to delete this piece? This action cannot be undone.');"
                                                        style="display:inline;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-sm btn-danger">
                                                            Delete
                                                        </button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="5" class="text-center">No pieces found. Click "Create New Piece"
                                                to add one.</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                {{-- Paginasi (jika Anda menggunakan paginasi di controller) --}}
                {{-- <div class="mt-3">
                {{ $pieces->links() }}
            </div> --}}
            </div>
        </div>
    </div>
@endsection
