@extends('layouts.backend_app')

@section('title', 'Dashboard - Site Analytics')

{{-- Push scripts dan styles untuk Chart.js dan Leaflet --}}
@push('scripts')
{{-- Asumsi Anda sudah mengimpor Chart.js di layout utama, jika belum, tambahkan ini: --}}
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script> 

{{-- Leaflet Maps - Tambahkan jika Anda memilih Leaflet --}}
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" integrity="sha256-p4NxAoJBhIIN+hmNHrzRCf9tD/SDAqqfRzSg7BCFjmY=" crossorigin=""/>
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js" integrity="sha256-20n6g96cO/h9FaTf/f3K52b3X4U5mR2sHhLz3b8S1U0=" crossorigin=""></script>
{{-- Leaflet Heatmap Plugin --}}
<script src="https://unpkg.com/leaflet.heatmap@1.0.0/leaflet.heatmap.js"></script>
@endpush

@section('content')
    <div class="container-fluid">
        <h1 class="mb-4">Dashboard Analitik ✨</h1>
        
        {{-- ============================== --}}
        {{-- ROW 1: STATISTIK KUNCI (KARTU) --}}
        {{-- ============================== --}}
        <div class="row">
            {{-- Total Kunjungan (Hits) --}}
            <div class="col-lg-4 col-md-6 mb-4">
                <div class="card bg-primary text-white">
                    <div class="card-body">
                        <h5 class="card-title text-white">Total Page Views 🌐</h5>
                        <h2 class="fw-bold display-5">{{ number_format($totalHits) }}</h2>
                        <p class="card-text">Total hits sejak pencatatan dimulai.</p>
                    </div>
                </div>
            </div>
            
            {{-- Pengunjung Unik (Sessions) --}}
            <div class="col-lg-4 col-md-6 mb-4">
                <div class="card bg-success text-white">
                    <div class="card-body">
                        <h5 class="card-title text-white">Unique Visitors 👤</h5>
                        <h2 class="fw-bold display-5">{{ number_format($uniqueVisitors) }}</h2>
                        <p class="card-text">Pengunjung unik berdasarkan sesi.</p>
                    </div>
                </div>
            </div>
            
            {{-- Rata-rata Harian (Sudah dihitung di Route) --}}
            <div class="col-lg-4 col-md-12 mb-4">
                <div class="card bg-warning text-white">
                    <div class="card-body">
                        <h5 class="card-title text-white">Avg. Daily Hits 📊</h5>
                        <h2 class="fw-bold display-5">{{ number_format($dailyAverage) }}</h2>
                        <p class="card-text">Rata-rata kunjungan per hari.</p>
                    </div>
                </div>
            </div>
        </div>

        {{-- ============================== --}}
        {{-- ROW 2: CHART & MAPS --}}
        {{-- ============================== --}}
        <div class="row">
            {{-- Kunjungan Harian Chart --}}
            <div class="col-lg-6 mb-4">
                <div class="card">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">Kunjungan Harian (30 Hari Terakhir)</h5>
                    </div>
                    <div class="card-body">
                        <canvas id="dailyVisitsChart" style="max-height: 350px;"></canvas>
                    </div>
                </div>
            </div>
            
            {{-- Geolokasi Maps --}}
            <div class="col-lg-6 mb-4">
                <div class="card">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">Geolokasi Pengunjung (Heatmap) 📍</h5>
                    </div>
                    <div class="card-body">
                        <div id="analyticsMap" style="height: 350px;"></div>
                    </div>
                </div>
            </div>
        </div>
        
        {{-- ============================== --}}
        {{-- ROW 3: RIWAYAT TERBARU --}}
        {{-- ============================== --}}
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">Riwayat Kunjungan Terbaru</h5>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead>
                                    <tr>
                                        <th>Waktu</th>
                                        <th>Negara</th>
                                        <th>Kota</th>
                                        <th>URL</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($recentVisits as $visit)
                                        <tr>
                                            <td>{{ $visit->created_at->diffForHumans() }}</td>
                                            <td>{{ $visit->country ?? 'N/A' }}</td>
                                            <td>{{ $visit->city ?? 'N/A' }}</td>
                                            <td><small class="text-muted">{{ Str::limit($visit->url, 50) }}</small></td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="4" class="text-center">Belum ada kunjungan yang tercatat.</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script>
    // Data dari Laravel
    const dailyData = @json($dailyVisits);
    const geoData = @json($geoData);
    
    // ==============================================
    // 1. CHARTJS: Kunjungan Harian
    // ==============================================
    const dates = dailyData.map(item => item.date);
    const counts = dailyData.map(item => item.count);

    const ctx = document.getElementById('dailyVisitsChart').getContext('2d');
    new Chart(ctx, {
        type: 'line',
        data: {
            labels: dates,
            datasets: [{
                label: 'Total Kunjungan',
                data: counts,
                backgroundColor: 'rgba(124, 92, 255, 0.2)', 
                borderColor: 'rgba(124, 92, 255, 1)',      
                borderWidth: 2,
                tension: 0.4,
                fill: true
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true
                }
            },
            plugins: {
                legend: {
                    display: false
                }
            }
        }
    });

    // ==============================================
    // 2. LEAFLET MAPS: HEATMAP (Sederhana)
    // ==============================================
    var mymap = L.map('analyticsMap').setView([0, 0], 2); 

    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
    }).addTo(mymap);
    
    // Data Dummy Koordinat untuk Heatmap
    const maxVisits = Math.max(0, ...Object.values(geoData)); // Tambahkan 0 untuk menghindari error
    const heatmapPoints = [];

    // Koordinat pusat beberapa negara (Untuk demo)
    const countryCoords = {
        'Indonesia': [0.7893, 113.9213],
        'United States': [39.8333, -98.5833],
        'Germany': [51.1657, 10.4515],
    }; 

    for (const country in geoData) {
        if (countryCoords[country]) {
            // Normalisasi intensitas dari 0 ke 100
            heatmapPoints.push([
                countryCoords[country][0], 
                countryCoords[country][1], 
                geoData[country] / maxVisits * 100 
            ]);
        }
    }
    
    if (heatmapPoints.length > 0) {
         L.heatmap(heatmapPoints, {
            radius: 25, 
            blur: 15,
            gradient: {0.0: '#dddddd', 0.6: '#444444', 1.0: '#000000'} 
        }).addTo(mymap);
    }
    
</script>
@endpush