<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
      Schema::create('links', function (Blueprint $table) {
            $table->id();

            // Nama platform media sosial (e.g., 'Instagram', 'LinkedIn', 'GitHub')
            $table->string('name', 50)->unique();

            // URL lengkap profil media sosial
            $table->string('url')->unique();

            // Kelas ikon yang akan digunakan (e.g., 'bi-github', 'bi-instagram')
            $table->string('icon', 50)->nullable();

            // Kolom opsional untuk pengurutan tampilan
            $table->integer('order')->default(0);

            $table->timestamps();
        });

        $links = [
            [
                'name' => 'GitHub',
                'url' => 'https://github.com/username_anda',
                'icon' => 'bi-github',
                'order' => 1,
                'created_at' => now(), // Tambahkan timestamp
                'updated_at' => now(),
            ],
            [
                'name' => 'LinkedIn',
                'url' => 'https://linkedin.com/in/username_anda',
                'icon' => 'bi-linkedin',
                'order' => 2,
                'created_at' => now(), // Tambahkan timestamp
                'updated_at' => now(),
            ],
            [
                'name' => 'Instagram',
                'url' => 'https://instagram.com/username_anda',
                'icon' => 'bi-instagram',
                'order' => 3,
                'created_at' => now(), // Tambahkan timestamp
                'updated_at' => now(),
            ],
        ];

        DB::table('links')->insert($links);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('links');
    }
};
