<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('insights', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('summary');
            $table->string('keyword');
            $table->string('color')->nullable(); // Warna opsional
            $table->timestamps();
        });

        // Insert 10 data ke dalam tabel 'insights'
        DB::table('insights')->insert([
            [
                'title' => 'Generative Tools',
                'summary' => 'Sebuah pemikiran tentang alat-alat generatif dan dampaknya pada kreativitas.',
                'keyword' => 'tools',
                'color' => '#804080', /* Ungu */
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'The Art of Data',
                'summary' => 'Menjelajahi bagaimana data dapat diubah menjadi bentuk seni visual yang menarik.',
                'keyword' => 'data',
                'color' => '#008080', /* Teal */
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Creative Coding Paradigms',
                'summary' => 'Memahami berbagai pendekatan dan bahasa pemrograman untuk seni generatif.',
                'keyword' => 'coding',
                'color' => '#FF5733', /* Oranye */
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Visual Storytelling',
                'summary' => 'Panduan untuk menceritakan kisah yang kuat melalui media visual interaktif.',
                'keyword' => 'storytelling',
                'color' => '#5D3FD3', /* Indigo */
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'AI and Human Collaboration',
                'summary' => 'Bagaimana kolaborasi antara manusia dan AI dapat membuka babak baru dalam seni dan desain.',
                'keyword' => 'ai',
                'color' => '#FFC300', /* Emas */
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Interactive Installations',
                'summary' => 'Studi kasus tentang instalasi seni interaktif yang memukau audiens.',
                'keyword' => 'installation',
                'color' => '#008000', /* Hijau */
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Motion Graphics & Brand Identity',
                'summary' => 'Pengaruh motion graphics dalam memperkuat identitas merek di era digital.',
                'keyword' => 'branding',
                'color' => '#C70039', /* Merah Maroon */
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Future of Digital Media',
                'summary' => 'Prediksi dan tren yang akan membentuk lanskap media digital di masa depan.',
                'keyword' => 'future',
                'color' => '#581845', /* Ungu Tua */
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Algorithmic Art',
                'summary' => 'Membuat karya seni menggunakan algoritma matematis dan logika komputer.',
                'keyword' => 'art',
                'color' => '#007FFF', /* Azure */
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Sound and Vision',
                'summary' => 'Sinkronisasi visual dengan audio untuk menciptakan pengalaman multisensori.',
                'keyword' => 'sound',
                'color' => '#FF7F50', /* Coral */
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('insights');
    }
};
