<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('services', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('description');
            $table->string('icon');
            $table->timestamps();
        });

        // Insert data ke dalam tabel 'services' dengan gaya yang lebih kreatif dan metaforis
        DB::table('services')->insert([
            [
                'title' => 'Building Digital Playgrounds',
                'description' => 'Architecting robust, full-stack web platforms and interactive online spaces that are fast, resilient, and engaging.',
                'icon' => 'bi-globe-americas', // Web/Global focus
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                // REVISI INI: Fokus pada integrasi data, bukan sculpting hardware
                'title' => 'Real-Time Data Alchemy',
                'description' => 'Integrating data streams from physical hardware (IoT) to the cloud, building reliable APIs and dashboards for monitoring and command systems.',
                'icon' => 'bi-cloud-check', // Cloud/Data focus
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Translating Concept to Canvas',
                'description' => 'Crafting intuitive user journeys (UX) and visually compelling interfaces (UI) that transform complex ideas into simple, elegant digital experiences.',
                'icon' => 'bi-bezier2', // Design/Curve focus
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Interactive Storytelling',
                'description' => 'Creating immersive digital art, 3D visualizations, and interactive installations that engage the audience using WebGL, projection mapping, or physical computing.',
                'icon' => 'bi-lightning', // Interactive/Energy focus
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('services');
    }
};
