<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('experiments', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('subtitle')->nullable();
            $table->text('description')->nullable();
            $table->json('tags')->nullable();
            $table->string('slug')->unique();
            $table->string('url')->nullable();
            $table->string('cover_path')->nullable();

            $table->timestamps();
        });

        // Insert 10 data sampel untuk tabel 'experiments'
        $experiments = [
            [
                'title' => 'Studi Eksperimental CSS Grid Interaktif',
                'subtitle' => 'Mencoba Tata Letak Responsif dengan Interaksi',
                'description' => 'Eksplorasi penggunaan CSS Grid untuk menciptakan tata letak dinamis yang bereaksi terhadap interaksi pengguna.',
                'tags' => json_encode(['CSS', 'Grid', 'Animation', 'Front-End']),
                'slug' => Str::slug('Studi Eksperimental CSS Grid Interaktif'),
                'url' => 'https://example.com/exp-css-grid',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Eksperimen Animasi Lottie untuk Web',
                'subtitle' => 'Integrasi dan Kustomisasi Animasi Vektor',
                'description' => 'Mempelajari cara mengintegrasikan dan memanipulasi file animasi Lottie untuk meningkatkan daya tarik visual website.',
                'tags' => json_encode(['Lottie', 'Animation', 'JavaScript']),
                'slug' => Str::slug('Eksperimen Animasi Lottie untuk Web'),
                'url' => null,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Pembangunan Prototipe Aplikasi Chatbot AI',
                'subtitle' => 'Pengembangan Back-End Sederhana dengan OpenAI API',
                'description' => 'Proyek kecil untuk membuat prototipe chatbot sederhana yang berinteraksi dengan API OpenAI.',
                'tags' => json_encode(['AI', 'Chatbot', 'API', 'Back-End']),
                'slug' => Str::slug('Pembangunan Prototipe Aplikasi Chatbot AI'),
                'url' => null,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Studi Penggunaan Tailwind CSS untuk Desain Holistik',
                'subtitle' => 'Membuat Sistem Desain Komprehensif',
                'description' => 'Eksperimen dengan Tailwind CSS untuk membangun sistem desain yang dapat diskalakan dan efisien.',
                'tags' => json_encode(['Tailwind', 'CSS', 'Design System']),
                'slug' => Str::slug('Studi Penggunaan Tailwind CSS untuk Desain Holistik'),
                'url' => 'https://example.com/exp-tailwind-design',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Visualisasi Data Interaktif dengan D3.js',
                'subtitle' => 'Menggambar Grafik dan Peta Dinamis',
                'description' => 'Mencoba membuat visualisasi data yang kompleks dan interaktif menggunakan library D3.js.',
                'tags' => json_encode(['Data Visualization', 'D3.js', 'JavaScript']),
                'slug' => Str::slug('Visualisasi Data Interaktif dengan D3js'),
                'url' => null,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Proyek Generasi Gambar AI dengan Stable Diffusion',
                'subtitle' => 'Eksperimen dengan Prompt dan Model',
                'description' => 'Mengeksplorasi kemampuan dan batasan model AI Stable Diffusion untuk menciptakan gambar-gambar unik.',
                'tags' => json_encode(['AI', 'Stable Diffusion', 'Image Generation']),
                'slug' => Str::slug('Proyek Generasi Gambar AI dengan Stable Diffusion'),
                'url' => null,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Sistem Komponen UI Reusable dengan React',
                'subtitle' => 'Studi Pengembangan Antarmuka dengan Komponen',
                'description' => 'Membangun pustaka komponen UI yang dapat digunakan kembali untuk mempercepat alur kerja pengembangan.',
                'tags' => json_encode(['React', 'Component', 'Front-End']),
                'slug' => Str::slug('Sistem Komponen UI Reusable dengan React'),
                'url' => 'https://example.com/react-component-lib',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Pembuatan Game Sederhana dengan JavaScript Murni',
                'subtitle' => 'Eksperimen dengan Game Loop dan Canvas',
                'description' => 'Proyek untuk membuat game web kecil tanpa framework, hanya menggunakan HTML5 Canvas dan JavaScript.',
                'tags' => json_encode(['JavaScript', 'GameDev', 'Canvas']),
                'slug' => Str::slug('Pembuatan Game Sederhana dengan JavaScript Murni'),
                'url' => null,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Eksperimen Rendering 3D dengan Three.js',
                'subtitle' => 'Mencoba Grafik Interaktif Berbasis WebGL',
                'description' => 'Eksplorasi pembuatan scene 3D sederhana, model, dan pencahayaan menggunakan Three.js.',
                'tags' => json_encode(['Three.js', '3D', 'WebGL']),
                'slug' => Str::slug('Eksperimen Rendering 3D dengan Threejs'),
                'url' => null,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Desain Landing Page Berbasis Micro-Animation',
                'subtitle' => 'Studi Efek Gerakan Halus pada Antarmuka',
                'description' => 'Mencoba mengimplementasikan berbagai efek micro-animation untuk meningkatkan pengalaman pengguna.',
                'tags' => json_encode(['Animation', 'UI/UX', 'Landing Page']),
                'slug' => Str::slug('Desain Landing Page Berbasis Micro-Animation'),
                'url' => 'https://example.com/micro-animation',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        DB::table('experiments')->insert($experiments);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('experiments');
    }
};
