<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('works', function (Blueprint $table) {
            $table->id();

            // Kolom-kolom baru
            $table->string('title');
            $table->string('subtitle')->nullable();
            $table->text('description')->nullable();
            $table->json('tags')->nullable();
            $table->string('slug')->unique();
            $table->string('url')->nullable();
            $table->string('cover_path')->nullable();

            $table->timestamps();
        });

        $works = [
            [
                'title' => 'Website Portfolio Modern',
                'subtitle' => 'Desain UX/UI & Pengembangan Front-End',
                'description' => 'Menciptakan pengalaman web yang interaktif dan responsif untuk portofolio digital.',
                'tags' => json_encode(['Web Design', 'UI/UX', 'Front-End']),
                'slug' => Str::slug('Website Portfolio Modern'),
                'url' => 'https://example.com/portfolio-modern',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Aplikasi Mobile untuk E-Commerce',
                'subtitle' => 'Pengembangan Aplikasi iOS & Android',
                'description' => 'Membangun aplikasi e-commerce multi-platform dengan fitur keranjang belanja dan notifikasi.',
                'tags' => json_encode(['Mobile App', 'E-Commerce', 'Cross-Platform']),
                'slug' => Str::slug('Aplikasi Mobile untuk E-Commerce'),
                'url' => null,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Kampanye Branding & Identitas Visual',
                'subtitle' => 'Strategi Merek & Desain Logo',
                'description' => 'Pengembangan identitas merek yang kohesif dari konsep hingga peluncuran.',
                'tags' => json_encode(['Branding', 'Visual Identity', 'Marketing']),
                'slug' => Str::slug('Kampanye Branding & Identitas Visual'),
                'url' => null,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Sistem Manajemen Konten Kustom',
                'subtitle' => 'Pengembangan Back-End dengan Laravel',
                'description' => 'Membangun CMS yang fleksibel dan aman untuk mengelola konten website dengan mudah.',
                'tags' => json_encode(['Back-End', 'Laravel', 'CMS']),
                'slug' => Str::slug('Sistem Manajemen Konten Kustom'),
                'url' => 'https://example.com/custom-cms',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Animasi 3D untuk Promosi Produk',
                'subtitle' => 'Desain Grafis & Motion Graphics',
                'description' => 'Membuat animasi 3D yang memukau untuk menyorot fitur-fitur produk.',
                'tags' => json_encode(['3D Animation', 'Motion Graphics', 'Design']),
                'slug' => Str::slug('Animasi 3D untuk Promosi Produk'),
                'url' => null,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Web Aplikasi untuk Pengelolaan Proyek',
                'subtitle' => 'Pembangunan Aplikasi Web & Integrasi API',
                'description' => 'Sebuah alat berbasis web untuk membantu tim mengorganisir tugas dan melacak kemajuan proyek.',
                'tags' => json_encode(['Web App', 'Project Management', 'API']),
                'slug' => Str::slug('Web Aplikasi untuk Pengelolaan Proyek'),
                'url' => 'https://example.com/project-app',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Desain Antarmuka Pengguna untuk Perangkat IoT',
                'subtitle' => 'UI/UX untuk Ekosistem Smart Home',
                'description' => 'Merancang antarmuka yang intuitif dan mudah digunakan untuk mengontrol perangkat pintar.',
                'tags' => json_encode(['UI/UX', 'IoT', 'Smart Home']),
                'slug' => Str::slug('Desain Antarmuka Pengguna untuk Perangkat IoT'),
                'url' => null,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Pengembangan Website Restoran',
                'subtitle' => 'Desain Web & Sistem Pemesanan Online',
                'description' => 'Website lengkap dengan menu interaktif dan sistem reservasi meja.',
                'tags' => json_encode(['Web Development', 'Restaurant', 'E-Commerce']),
                'slug' => Str::slug('Pengembangan Website Restoran'),
                'url' => 'https://example.com/resto-website',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Ilustrasi Digital untuk Buku Anak-Anak',
                'subtitle' => 'Konsep Seni & Gaya Ilustrasi',
                'description' => 'Kumpulan ilustrasi berwarna-warni yang dibuat untuk cerita anak-anak.',
                'tags' => json_encode(['Illustration', 'Art', 'Children\'s Book']),
                'slug' => Str::slug('Ilustrasi Digital untuk Buku Anak-Anak'),
                'url' => null,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Desain Kemasan Produk Organik',
                'subtitle' => 'Desain Grafis & Merek',
                'description' => 'Desain kemasan yang ramah lingkungan dan mencerminkan nilai-nilai produk organik.',
                'tags' => json_encode(['Packaging Design', 'Graphic Design', 'Branding']),
                'slug' => Str::slug('Desain Kemasan Produk Organik'),
                'url' => null,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        DB::table('works')->insert($works);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('works');
    }
};
