<?php

namespace App\Traits;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

trait HasMedia
{
    protected function handleMedia(Model $model, Request $request, $inputName = 'media_files')
    {
        // 1. Ambil data urutan yang dikirim dari form
        $orderData = $request->filled('media_order_data') ? json_decode($request->input('media_order_data'), true) : [];

        // 2. Hapus media yang ditandai untuk dihapus
        $this->deleteMedia($model, $request);

        // 3. Simpan media baru terlebih dahulu dan buat map ID sementara ke ID asli
        $tempToNewIdMap = [];
        $files = $request->file($inputName) ?? [];

        foreach ($files as $tempId => $file) {
            if ($file instanceof UploadedFile && $file->isValid()) {
                $fileName = time() . '_' . Str::random(10) . '.' . $file->getClientOriginalExtension();
                $mediaDirectory = Str::slug(Str::plural(class_basename($model)));
                $filePath = $file->storeAs("{$mediaDirectory}/media", $fileName, 'public');

                $newMediaItem = $model->media()->create([
                    'file_name' => $fileName,
                    'file_path' => $filePath,
                    'file_type' => $file->getClientMimeType(),
                    'file_size' => $file->getSize(),
                ]);
                $tempToNewIdMap[$tempId] = $newMediaItem->id;
            }
        }

        // 4. Perbarui urutan dan baris semua media berdasarkan data urutan dari form
        foreach ($orderData as $item) {
            $mediaId = $item['id'];

            // Jika ID adalah ID sementara, gunakan ID asli dari map
            if (is_string($mediaId) && Str::startsWith($mediaId, 'new_')) {
                $mediaId = $tempToNewIdMap[Str::after($mediaId, 'new_')];
            }

            $media = $model->media()->find($mediaId);
            if ($media) {
                $media->update([
                    'details' => [
                        'row' => $item['row'],
                        'order' => $item['order']
                    ]
                ]);
            }
        }
    }

    protected function deleteMedia(Model $model, Request $request)
    {
        if ($request->filled('deleted_media_ids')) {
            $deletedMediaIds = explode(',', $request->input('deleted_media_ids'));

            foreach ($deletedMediaIds as $mediaId) {
                $media = $model->media()->find($mediaId);

                if ($media) {
                    Storage::disk('public')->delete($media->file_path);
                    $media->delete();
                }
            }
        }
    }
}
