<?php

namespace App\Models;

use App\Models\Media;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Work extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'subtitle',
        'description',
        'tags',
        'slug',
        'url',
    ];

    protected $casts = [
        'tags' => 'array',
    ];

    /**
     * Get all of the work's media.
     */
    public function media()
    {
        return $this->morphMany(Media::class, 'mediable');
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($work) {
            $work->slug = Str::slug($work->title);
        });

        static::updating(function ($work) {
            if ($work->isDirty('title')) {
                $work->slug = Str::slug($work->title);
            }
        });

        // Delete associated media when a work is deleted
        static::deleting(function ($work) {
            $work->media()->each(function ($media) {
                // Delete file from storage
                if (Storage::disk('public')->exists($media->file_path)) {
                    Storage::disk('public')->delete($media->file_path);
                }
                // Delete media record
                $media->delete();
            });
        });
    }
}
